/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.utils;

import java.util.concurrent.ConcurrentSkipListMap;
import pl.skidam.automodpack_loader_core.utils.DownloadManager;

public class SpeedMeter {
    private final DownloadManager downloadManager;
    private final ConcurrentSkipListMap<Long, Long> bytesDownloadedPerSec = new ConcurrentSkipListMap();
    private static final int MAX_ENTRIES = 5;

    public SpeedMeter(DownloadManager downloadManager) {
        this.downloadManager = downloadManager;
    }

    public synchronized void addDownloadedBytes(long newBytes) {
        long bucketedTime = System.currentTimeMillis() / 1000L * 1000L;
        this.bytesDownloadedPerSec.merge(bucketedTime, newBytes, Long::sum);
        while (this.bytesDownloadedPerSec.size() > 5) {
            this.bytesDownloadedPerSec.pollFirstEntry();
        }
    }

    public synchronized long getCurrentSpeedInBytes() {
        long lastTimeBucket = System.currentTimeMillis() / 1000L * 1000L - 1000L;
        Long value = -1L;
        if (this.bytesDownloadedPerSec.containsKey(lastTimeBucket)) {
            value = this.bytesDownloadedPerSec.get(lastTimeBucket);
        } else if (this.bytesDownloadedPerSec.containsKey(lastTimeBucket - 1000L)) {
            value = this.bytesDownloadedPerSec.get(lastTimeBucket - 1000L);
        }
        return value != null ? value : -1L;
    }

    public long getETAInSeconds() {
        long totalBytesRemaining = this.downloadManager.getTotalBytesRemaining();
        long speed = this.getCurrentSpeedInBytes();
        if (speed <= 0L) {
            return -1L;
        }
        return totalBytesRemaining / speed;
    }

    public static String formatDownloadSpeedToMbps(long currentSpeedInBytes) {
        if (currentSpeedInBytes < 0L) {
            return "-1";
        }
        long bitsPerSecond = currentSpeedInBytes * 8L;
        double mbps = (double)bitsPerSecond / 1000000.0;
        return String.format("%.2f Mbps", mbps);
    }

    public static String formatETAToSeconds(long seconds) {
        if (seconds < 0L) {
            return "-1";
        }
        return String.format("%02d:%02d:%02d", seconds / 3600L, seconds % 3600L / 60L, seconds % 60L);
    }
}

