/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.math2d;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.mc.common.math2d.Rect2dKt;
import org.anti_ad.mc.common.math2d.Size;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nH\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nH\u0086\u0002\u00a2\u0006\u0004\b\u0010\u0010\rJ\u0018\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0012J$\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u0012J\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010\u0012R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001e\u001a\u0004\b \u0010\u0012\u00a8\u0006!"}, d2={"Lorg/anti_ad/mc/common/math2d/Point;", "", "", "x", "y", "<init>", "(II)V", "unaryPlus", "()Lorg/anti_ad/mc/common/math2d/Point;", "unaryMinus", "Lorg/anti_ad/mc/common/math2d/Size;", "size", "minus", "(Lorg/anti_ad/mc/common/math2d/Size;)Lorg/anti_ad/mc/common/math2d/Point;", "point", "(Lorg/anti_ad/mc/common/math2d/Point;)Lorg/anti_ad/mc/common/math2d/Point;", "plus", "component1", "()I", "component2", "copy", "(II)Lorg/anti_ad/mc/common/math2d/Point;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getX", "getY", "fabric-1.21.4"})
public final class Point {
    private final int x;
    private final int y;

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    @NotNull
    public final Point unaryPlus() {
        return this;
    }

    @NotNull
    public final Point unaryMinus() {
        return new Point(-this.x, -this.y);
    }

    @NotNull
    public final Point minus(@NotNull Size size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return this.minus(Rect2dKt.toPoint(size));
    }

    @NotNull
    public final Point minus(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.plus(point.unaryMinus());
    }

    @NotNull
    public final Point plus(@NotNull Size size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return this.plus(Rect2dKt.toPoint(size));
    }

    @NotNull
    public final Point plus(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return new Point(this.x + point.x, this.y + point.y);
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    @NotNull
    public final Point copy(int x, int y) {
        return new Point(x, y);
    }

    public static /* synthetic */ Point copy$default(Point point, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = point.x;
        }
        if ((n3 & 2) != 0) {
            n2 = point.y;
        }
        return point.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "Point(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.x);
        result = result * 31 + Integer.hashCode(this.y);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Point)) {
            return false;
        }
        Point point = (Point)other;
        if (this.x != point.x) {
            return false;
        }
        return this.y == point.y;
    }
}

