/*
 * Decompiled with CFR 0.152.
 */
package com.vendoau.maptooltip;

import com.vendoau.maptooltip.Constants;
import com.vendoau.maptooltip.mixin.ClientLevelAccessor;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_7225;
import net.minecraft.class_9209;
import org.jetbrains.annotations.Nullable;

public class MapCache {
    private static final List<class_9209> cachedIds = new ArrayList<class_9209>();

    public static void load(class_642 server, class_638 level) {
        if (server == null) {
            return;
        }
        Constants.LOGGER.info("Loading map data for {}", (Object)server.field_3761);
        Path serverDir = MapCache.getServerDir(server);
        if (!Files.exists(serverDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(serverDir);){
            cachedIds.clear();
            paths.forEach(path -> MapCache.load(path, level));
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to load map data");
            Constants.LOGGER.error("{}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    private static void load(Path path, class_638 level) {
        class_9209 mapId = MapCache.getMapIdFromPath(path);
        try {
            class_2487 tag = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898()).method_10562("data");
            class_22 data = class_22.method_32371((class_2487)tag, (class_7225.class_7874)level.method_30349());
            Map<class_9209, class_22> mapIds = ((ClientLevelAccessor)level).getDataForMaps();
            mapIds.put(mapId, data);
            cachedIds.add(mapId);
            Constants.LOGGER.info("Loaded map data ({})", (Object)mapId.comp_2315());
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to load map data ({})", (Object)mapId.comp_2315());
            Constants.LOGGER.error("Data is probably corrupted, deleting...");
            MapCache.delete(path);
        }
    }

    private static void delete(Path path) {
        try {
            Files.deleteIfExists(path);
            Constants.LOGGER.info("File successfully deleted");
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to delete file");
        }
    }

    private static class_9209 getMapIdFromPath(Path path) {
        String fileName = path.getFileName().toString();
        int id = Integer.parseInt(fileName.substring(4, fileName.length() - 4));
        return new class_9209(id);
    }

    private static String getServerAddress(class_642 server) {
        String[] split = server.field_3761.split(":");
        String ip = split[0];
        if (ip.equals("127.0.0.1")) {
            ip = "localhost";
        }
        if (split.length == 1) {
            return ip;
        }
        String port = split[1];
        if (port.equals("25565")) {
            return ip;
        }
        return ip + "_" + port;
    }

    private static Path getServerDir(class_642 server) {
        String address = MapCache.getServerAddress(server);
        return Constants.CONFIG_DIR.resolve("cache").resolve(address);
    }

    public static void save(@Nullable class_642 server, class_638 level) {
        if (server == null) {
            return;
        }
        Constants.LOGGER.info("Saving map data for {}", (Object)server.field_3761);
        ((ClientLevelAccessor)level).getDataForMaps().forEach((mapId, data) -> {
            if (cachedIds.contains(mapId)) {
                return;
            }
            try {
                Path serverDir = MapCache.getServerDir(server);
                Files.createDirectories(serverDir, new FileAttribute[0]);
                class_5455 provider = level.method_30349();
                class_2487 savedData = data.method_17919((class_7225.class_7874)provider);
                Path path = serverDir.resolve(mapId.method_56814() + ".dat");
                class_2507.method_30614((class_2487)savedData, (Path)path);
                Constants.LOGGER.info("Saved map data ({})", (Object)mapId.comp_2315());
            }
            catch (IOException e) {
                Constants.LOGGER.error("Failed to save map data ({})", (Object)mapId.comp_2315());
                Constants.LOGGER.error("{}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            }
        });
    }

    public static void update(class_9209 mapId) {
        cachedIds.remove(mapId);
    }
}

