/*
 * Decompiled with CFR 0.152.
 */
package nickytea.mcinspects.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import nickytea.mcinspects.McInspects;

public class McInspectsClient
implements ClientModInitializer {
    private static final class_304 inspectBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keys.mcinspects.inspectitem", class_3675.class_307.field_1668, 82, "keys.category.mcinspects"));
    private static double currentStageElapsedTime = 0.0;
    private static float currentStageTime = 0.0f;
    private static boolean isInspecting = false;
    private static final float BASE_ANIMATION_TIME = 0.025f;
    private static final float S0_ANIMATION_TIME = 0.35f;
    private static final float PAUSE_ANIMATION_TIME = 0.6f;
    private static final float S2_ANIMATION_TIME = 0.4f;
    private static final float S4_ANIMATION_TIME = 0.45f;
    private static final int ANIMATION_STAGE_COUNT = 5;
    private static int animationStage = 0;
    private static long lastTime = 0L;

    public static boolean isInspecting() {
        long currentTime = System.nanoTime();
        double deltaTime = (double)(currentTime - lastTime) / 1.0E9;
        lastTime = currentTime;
        if (isInspecting) {
            McInspectsClient.updateAnimationTime();
            currentStageElapsedTime += deltaTime;
            if (currentStageElapsedTime >= (double)currentStageTime) {
                currentStageElapsedTime = 0.0;
                if (++animationStage >= 5) {
                    McInspectsClient.stopInspect();
                }
            }
        }
        return isInspecting;
    }

    private static void updateAnimationTime() {
        switch (animationStage) {
            case 0: {
                currentStageTime = 0.35f;
                break;
            }
            case 1: 
            case 3: {
                currentStageTime = 0.6f;
                break;
            }
            case 2: {
                currentStageTime = 0.4f;
                break;
            }
            case 4: {
                currentStageTime = 0.45f;
                break;
            }
            default: {
                currentStageTime = 0.025f;
            }
        }
    }

    public static double getCurrentStageElapsedTime() {
        return currentStageElapsedTime;
    }

    public static float getCurrentStageTime() {
        return currentStageTime;
    }

    public static int getAnimationStage() {
        return animationStage;
    }

    private static void startInspect() {
        isInspecting = true;
        currentStageElapsedTime = 0.0;
        animationStage = 0;
        currentStageTime = 0.025f;
        McInspects.LOGGER.info("Starting inspect animation...");
    }

    private static void stopInspect() {
        isInspecting = false;
        currentStageElapsedTime = 0.0;
        animationStage = 0;
        McInspects.LOGGER.info("Inspect animation complete");
    }

    public void onInitializeClient() {
        McInspects.LOGGER.info("MCInspects client initializing...");
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (inspectBinding.method_1436() && !isInspecting) {
                McInspectsClient.startInspect();
            }
        });
    }
}

