/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.shader;

import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.lwjgl.opengl.GL32;

public class Shader {
    public final int id;

    public Shader(int type2, String path, boolean absoluteFilePath) {
        GLProxy.GL_LOGGER.info("Loading shader at [" + path + "]", new Object[0]);
        this.id = GL32.glCreateShader((int)type2);
        if (this.id == 0) {
            throw new IllegalArgumentException("Failed to create shader with type [" + type2 + "].");
        }
        StringBuilder source = Shader.loadFile(path, absoluteFilePath, new StringBuilder());
        GL32.glShaderSource((int)this.id, (CharSequence)source);
        GL32.glCompileShader((int)this.id);
        int status = GL32.glGetShaderi((int)this.id, (int)35713);
        if (status != 1) {
            String message = "Shader compiler error. Details: [" + GL32.glGetShaderInfoLog((int)this.id) + "].";
            this.free();
            throw new RuntimeException(message);
        }
        GLProxy.GL_LOGGER.info("Shader at " + path + " loaded successfully.", new Object[0]);
    }

    public Shader(int type2, String sourceString) {
        GLProxy.GL_LOGGER.info("Loading shader with type: [" + type2 + "]", new Object[0]);
        GLProxy.GL_LOGGER.debug("Source: \n[" + sourceString + "]", new Object[0]);
        if (sourceString == null || sourceString.isEmpty()) {
            throw new IllegalArgumentException("No shader source given.");
        }
        this.id = GL32.glCreateShader((int)type2);
        if (this.id == 0) {
            throw new IllegalArgumentException("Failed to create shader with type [" + type2 + "] and Source: \n[" + sourceString + "].");
        }
        GL32.glShaderSource((int)this.id, (CharSequence)sourceString);
        GL32.glCompileShader((int)this.id);
        int status = GL32.glGetShaderi((int)this.id, (int)35713);
        if (status != 1) {
            String message = "Shader compiler error. Details: [" + GL32.glGetShaderInfoLog((int)this.id) + "]\n";
            message = message + "Source: \n[" + sourceString + "]";
            this.free();
            throw new RuntimeException(message);
        }
        GLProxy.GL_LOGGER.info("Shader loaded sucessfully.", new Object[0]);
    }

    public void free() {
        GL32.glDeleteShader((int)this.id);
    }

    public static StringBuilder loadFile(String path, boolean absoluteFilePath, StringBuilder stringBuilder) {
        try {
            String line;
            InputStream in;
            if (absoluteFilePath) {
                in = new FileInputStream(path);
            } else {
                in = Shader.class.getClassLoader().getResourceAsStream(path);
                if (in == null) {
                    throw new FileNotFoundException("Shader file not found in resource: " + path);
                }
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load shader from file [" + path + "]. Error: " + e.getMessage());
        }
        return stringBuilder;
    }
}

