/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messenger {
    public static final Logger LOG = LoggerFactory.getLogger((String)"Messaging System");
    private static final Pattern colorExtract = Pattern.compile("#([0-9a-fA-F]{6})");

    public static class_2583 parseStyle(String style) {
        class_2583 myStyle = class_2583.field_24360.method_10977(class_124.field_1068);
        for (CarpetFormatting cf : CarpetFormatting.values()) {
            myStyle = cf.apply(style, myStyle);
        }
        return myStyle;
    }

    public static String heatmap_color(double actual, double reference) {
        String color = "g";
        if (actual >= 0.0) {
            color = "e";
        }
        if (actual > 0.5 * reference) {
            color = "y";
        }
        if (actual > 0.8 * reference) {
            color = "r";
        }
        if (actual > reference) {
            color = "m";
        }
        return color;
    }

    public static String creatureTypeColor(class_1311 type) {
        return switch (type) {
            case class_1311.field_6302 -> "n";
            case class_1311.field_6294 -> "e";
            case class_1311.field_6303 -> "f";
            case class_1311.field_6300 -> "v";
            case class_1311.field_24460 -> "q";
            default -> "w";
        };
    }

    private static class_5250 getChatComponentFromDesc(String message, class_5250 previousMessage) {
        if (((String)message).equalsIgnoreCase("")) {
            return class_2561.method_43470((String)"");
        }
        if (Character.isWhitespace(((String)message).charAt(0))) {
            message = "w" + (String)message;
        }
        int limit = ((String)message).indexOf(32);
        Object desc = message;
        String str = "";
        if (limit >= 0) {
            desc = ((String)message).substring(0, limit);
            str = ((String)message).substring(limit + 1);
        }
        if (previousMessage == null) {
            class_5250 text = class_2561.method_43470((String)str);
            text.method_10862(Messenger.parseStyle((String)desc));
            return text;
        }
        class_2583 previousStyle = previousMessage.method_10866();
        class_5250 ret = previousMessage;
        previousMessage.method_10862(switch (((String)desc).charAt(0)) {
            case '?' -> previousStyle.method_10958(new class_2558(class_2558.class_2559.field_11745, ((String)message).substring(1)));
            case '!' -> previousStyle.method_10958(new class_2558(class_2558.class_2559.field_11750, ((String)message).substring(1)));
            case '^' -> previousStyle.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Messenger.c(((String)message).substring(1))));
            case '@' -> previousStyle.method_10958(new class_2558(class_2558.class_2559.field_11749, ((String)message).substring(1)));
            case '&' -> previousStyle.method_10958(new class_2558(class_2558.class_2559.field_21462, ((String)message).substring(1)));
            default -> {
                ret = class_2561.method_43470((String)str);
                ret.method_10862(Messenger.parseStyle((String)desc));
                yield previousStyle;
            }
        });
        return ret;
    }

    public static class_2561 tp(String desc, class_243 pos) {
        return Messenger.tp(desc, pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public static class_2561 tp(String desc, class_2338 pos) {
        return Messenger.tp(desc, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static class_2561 tp(String desc, double x, double y, double z) {
        return Messenger.tp(desc, (float)x, (float)y, (float)z);
    }

    public static class_2561 tp(String desc, float x, float y, float z) {
        return Messenger.getCoordsTextComponent(desc, x, y, z, false);
    }

    public static class_2561 tp(String desc, int x, int y, int z) {
        return Messenger.getCoordsTextComponent(desc, x, y, z, true);
    }

    public static class_2561 dbl(String style, double double_value) {
        return Messenger.c(String.format("%s %.1f", style, double_value), String.format("^w %f", double_value));
    }

    public static class_2561 dbls(String style, double ... doubles) {
        StringBuilder str = new StringBuilder(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            str.append(String.format("%s%.1f", prefix, dbl));
            prefix = ", ";
        }
        str.append(" ]");
        return Messenger.c(str.toString());
    }

    public static class_2561 dblf(String style, double ... doubles) {
        StringBuilder str = new StringBuilder(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            str.append(String.format("%s%f", prefix, dbl));
            prefix = ", ";
        }
        str.append(" ]");
        return Messenger.c(str.toString());
    }

    public static class_2561 dblt(String style, double ... doubles) {
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            components.add(String.format("%s %s%.1f", style, prefix, dbl));
            components.add("?" + dbl);
            components.add("^w " + dbl);
            prefix = ", ";
        }
        components.add(style + "  ]");
        return Messenger.c(components.toArray(new Object[0]));
    }

    private static class_2561 getCoordsTextComponent(String style, float x, float y, float z, boolean isInt) {
        String command;
        String text;
        if (isInt) {
            text = String.format("%s [ %d, %d, %d ]", style, (int)x, (int)y, (int)z);
            command = String.format("!/tp %d %d %d", (int)x, (int)y, (int)z);
        } else {
            text = String.format("%s [ %.1f, %.1f, %.1f]", style, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
            command = String.format("!/tp %.3f %.3f %.3f", Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
        }
        return Messenger.c(text, command);
    }

    public static void m(class_2168 source, Object ... fields) {
        if (source != null) {
            source.method_9226(() -> Messenger.c(fields), source.method_9211() != null && source.method_9211().method_30002() != null);
        }
    }

    public static void m(class_1657 player, Object ... fields) {
        ((class_3222)player).method_64398(Messenger.c(fields));
    }

    public static class_2561 c(Object ... fields) {
        class_5250 message = class_2561.method_43470((String)"");
        class_5250 previousComponent = null;
        for (Object o : fields) {
            if (o instanceof class_5250) {
                message.method_10852((class_2561)((class_5250)o));
                previousComponent = (class_5250)o;
                continue;
            }
            String txt = o.toString();
            class_5250 comp = Messenger.getChatComponentFromDesc(txt, previousComponent);
            if (comp != previousComponent) {
                message.method_10852((class_2561)comp);
            }
            previousComponent = comp;
        }
        return message;
    }

    public static class_2561 s(String text) {
        return Messenger.s(text, "");
    }

    public static class_2561 s(String text, String style) {
        class_5250 message = class_2561.method_43470((String)text);
        message.method_10862(Messenger.parseStyle(style));
        return message;
    }

    public static void send(class_1657 player, Collection<class_2561> lines) {
        lines.forEach(message -> ((class_3222)player).method_64398(message));
    }

    public static void send(class_2168 source, Collection<class_2561> lines) {
        lines.stream().forEachOrdered(s -> source.method_9226(() -> s, false));
    }

    public static void print_server_message(MinecraftServer server, String message) {
        if (server == null) {
            LOG.error("Message not delivered: " + message);
        }
        server.method_43496((class_2561)class_2561.method_43470((String)message));
        class_2561 txt = Messenger.c("gi " + message);
        for (class_3222 entityplayer : server.method_3760().method_14571()) {
            entityplayer.method_64398(txt);
        }
    }

    public static void print_server_message(MinecraftServer server, class_2561 message) {
        if (server == null) {
            LOG.error("Message not delivered: " + message.getString());
        }
        server.method_43496(message);
        for (class_3222 entityplayer : server.method_3760().method_14571()) {
            entityplayer.method_64398(message);
        }
    }

    public static enum CarpetFormatting {
        ITALIC('i', (s, f) -> s.method_10978(Boolean.valueOf(true))),
        STRIKE('s', (s, f) -> s.method_27706(class_124.field_1055)),
        UNDERLINE('u', (s, f) -> s.method_27706(class_124.field_1073)),
        BOLD('b', (s, f) -> s.method_10982(Boolean.valueOf(true))),
        OBFUSCATE('o', (s, f) -> s.method_27706(class_124.field_1051)),
        WHITE('w', (s, f) -> s.method_10977(class_124.field_1068)),
        YELLOW('y', (s, f) -> s.method_10977(class_124.field_1054)),
        LIGHT_PURPLE('m', (s, f) -> s.method_10977(class_124.field_1076)),
        RED('r', (s, f) -> s.method_10977(class_124.field_1061)),
        AQUA('c', (s, f) -> s.method_10977(class_124.field_1075)),
        GREEN('l', (s, f) -> s.method_10977(class_124.field_1060)),
        BLUE('t', (s, f) -> s.method_10977(class_124.field_1078)),
        DARK_GRAY('f', (s, f) -> s.method_10977(class_124.field_1063)),
        GRAY('g', (s, f) -> s.method_10977(class_124.field_1080)),
        GOLD('d', (s, f) -> s.method_10977(class_124.field_1065)),
        DARK_PURPLE('p', (s, f) -> s.method_10977(class_124.field_1064)),
        DARK_RED('n', (s, f) -> s.method_10977(class_124.field_1079)),
        DARK_AQUA('q', (s, f) -> s.method_10977(class_124.field_1062)),
        DARK_GREEN('e', (s, f) -> s.method_10977(class_124.field_1077)),
        DARK_BLUE('v', (s, f) -> s.method_10977(class_124.field_1058)),
        BLACK('k', (s, f) -> s.method_10977(class_124.field_1074)),
        COLOR('#', (s, f) -> {
            class_5251 color;
            try {
                color = (class_5251)class_5251.method_27719((String)("#" + f)).getOrThrow(RuntimeException::new);
            }
            catch (RuntimeException e) {
                return s;
            }
            return color == null ? s : s.method_27703(color);
        }, s -> {
            Matcher m = colorExtract.matcher((CharSequence)s);
            return m.find() ? m.group(1) : null;
        });

        public char code;
        public BiFunction<class_2583, String, class_2583> applier;
        public Function<String, String> container;

        private CarpetFormatting(char code, BiFunction<class_2583, String, class_2583> applier) {
            this(code, applier, s -> s.indexOf(code) >= 0 ? Character.toString(code) : null);
        }

        private CarpetFormatting(char code, BiFunction<class_2583, String, class_2583> applier, Function<String, String> container) {
            this.code = code;
            this.applier = applier;
            this.container = container;
        }

        public class_2583 apply(String format, class_2583 previous) {
            String fmt = this.container.apply(format);
            if (fmt != null) {
                return this.applier.apply(previous, fmt);
            }
            return previous;
        }
    }
}

