/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.util;

import foundationgames.enhancedblockentities.EnhancedBlockEntities;
import foundationgames.enhancedblockentities.client.resource.EBEPack;
import foundationgames.enhancedblockentities.client.resource.template.TemplateProvider;
import foundationgames.enhancedblockentities.util.EBEUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1767;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4722;
import net.minecraft.class_5321;
import net.minecraft.class_9766;
import org.jetbrains.annotations.Nullable;

public final class ResourceUtil
extends Enum<ResourceUtil> {
    private static EBEPack BASE_PACK;
    private static EBEPack TOP_LEVEL_PACK;
    private static final /* synthetic */ ResourceUtil[] $VALUES;

    public static ResourceUtil[] values() {
        return (ResourceUtil[])$VALUES.clone();
    }

    public static ResourceUtil valueOf(String name) {
        return Enum.valueOf(ResourceUtil.class, name);
    }

    public static void addChestItemDefinition(String chestName, String centerChest, EBEPack pack) {
        pack.addTemplateResource(class_2960.method_60654((String)("items/" + chestName + ".json")), t -> t.load("item/chest_item.json", d -> d.def("chest", centerChest)));
    }

    public static void addBedItemDefinition(String bedColor, EBEPack pack) {
        pack.addTemplateResource(class_2960.method_60654((String)("items/" + bedColor + "_bed.json")), t -> t.load("item/bed.json", d -> d.def("head", bedColor + "_bed_head").def("foot", bedColor + "_bed_foot")));
        pack.addTemplateResource(class_2960.method_60654((String)("models/item/" + bedColor + "_bed_head.json")), t -> t.load("model/bed_head_item.json", d -> d.def("bed", bedColor)));
        pack.addTemplateResource(class_2960.method_60654((String)("models/item/" + bedColor + "_bed_foot.json")), t -> t.load("model/bed_foot_item.json", d -> d.def("bed", bedColor)));
    }

    private static String list(String ... els) {
        return String.join((CharSequence)",", els);
    }

    private static String kv(String k, String v) {
        return String.format("\"" + k + "\":\"" + v + "\"", new Object[0]);
    }

    private static String kv(String k, int v) {
        return String.format("\"" + k + "\":" + v, new Object[0]);
    }

    private static String variant(TemplateProvider t, String state, String model) throws IOException {
        return t.load("blockstate/var.json", d -> d.def("state", state).def("model", model).def("extra", ""));
    }

    private static String variantY(TemplateProvider t, String state, String model, int y) throws IOException {
        return t.load("blockstate/var.json", d -> d.def("state", state).def("model", model).def("extra", ResourceUtil.kv("y", y) + ","));
    }

    private static String variantXY(TemplateProvider t, String state, String model, int x, int y) throws IOException {
        return t.load("blockstate/var.json", d -> d.def("state", state).def("model", model).def("extra", ResourceUtil.list(ResourceUtil.kv("x", x), ResourceUtil.kv("y", y)) + ","));
    }

    private static String variantRotation16(TemplateProvider t, String keyPrefix, String modelPrefix) throws IOException {
        return ResourceUtil.list(ResourceUtil.variantY(t, keyPrefix + "0", modelPrefix + "_0", 180), ResourceUtil.variantY(t, keyPrefix + "1", modelPrefix + "_67_5", 270), ResourceUtil.variantY(t, keyPrefix + "2", modelPrefix + "_45", 270), ResourceUtil.variantY(t, keyPrefix + "3", modelPrefix + "_22_5", 270), ResourceUtil.variantY(t, keyPrefix + "4", modelPrefix + "_0", 270), ResourceUtil.variant(t, keyPrefix + "5", modelPrefix + "_67_5"), ResourceUtil.variant(t, keyPrefix + "6", modelPrefix + "_45"), ResourceUtil.variant(t, keyPrefix + "7", modelPrefix + "_22_5"), ResourceUtil.variant(t, keyPrefix + "8", modelPrefix + "_0"), ResourceUtil.variantY(t, keyPrefix + "9", modelPrefix + "_67_5", 90), ResourceUtil.variantY(t, keyPrefix + "10", modelPrefix + "_45", 90), ResourceUtil.variantY(t, keyPrefix + "11", modelPrefix + "_22_5", 90), ResourceUtil.variantY(t, keyPrefix + "12", modelPrefix + "_0", 90), ResourceUtil.variantY(t, keyPrefix + "13", modelPrefix + "_67_5", 180), ResourceUtil.variantY(t, keyPrefix + "14", modelPrefix + "_45", 180), ResourceUtil.variantY(t, keyPrefix + "15", modelPrefix + "_22_5", 180));
    }

    private static String variantHFacing(TemplateProvider t, String keyPrefix, String model) throws IOException {
        return ResourceUtil.list(ResourceUtil.variant(t, keyPrefix + "north", model), ResourceUtil.variantY(t, keyPrefix + "west", model, 270), ResourceUtil.variantY(t, keyPrefix + "south", model, 180), ResourceUtil.variantY(t, keyPrefix + "east", model, 90));
    }

    private static void addChestLikeModel(String parent, String chestTex, String chestName, class_2960 id, EBEPack pack) {
        pack.addTemplateResource(class_2960.method_60655((String)id.method_12836(), (String)("models/" + id.method_12832() + ".json")), t -> t.load("model/chest_like.json", d -> d.def("parent", parent).def("chest_tex", chestTex).def("particle", ResourceUtil.chestParticle(chestName))));
    }

    public static void addSingleChestModels(String chestTex, String chestName, EBEPack pack) {
        ResourceUtil.addChestLikeModel("template_chest_center", chestTex, chestName, class_2960.method_60654((String)("block/" + chestName + "_center")), pack);
        ResourceUtil.addChestLikeModel("template_chest_center_lid", chestTex, chestName, class_2960.method_60654((String)("block/" + chestName + "_center_lid")), pack);
        ResourceUtil.addChestLikeModel("template_chest_center_trunk", chestTex, chestName, class_2960.method_60654((String)("block/" + chestName + "_center_trunk")), pack);
    }

    public static void addDoubleChestModels(String leftTex, String rightTex, String chestName, EBEPack pack) {
        ResourceUtil.addChestLikeModel("template_chest_left", leftTex, chestName, class_2960.method_60654((String)("block/" + chestName + "_left")), pack);
        ResourceUtil.addChestLikeModel("template_chest_left_lid", leftTex, chestName, class_2960.method_60654((String)("block/" + chestName + "_left_lid")), pack);
        ResourceUtil.addChestLikeModel("template_chest_left_trunk", leftTex, chestName, class_2960.method_60654((String)("block/" + chestName + "_left_trunk")), pack);
        ResourceUtil.addChestLikeModel("template_chest_right", rightTex, chestName, class_2960.method_60654((String)("block/" + chestName + "_right")), pack);
        ResourceUtil.addChestLikeModel("template_chest_right_lid", rightTex, chestName, class_2960.method_60654((String)("block/" + chestName + "_right_lid")), pack);
        ResourceUtil.addChestLikeModel("template_chest_right_trunk", rightTex, chestName, class_2960.method_60654((String)("block/" + chestName + "_right_trunk")), pack);
    }

    private static String chestParticle(String chestName) {
        if (EnhancedBlockEntities.CONFIG.experimentalChests) {
            return ResourceUtil.kv("particle", "block/" + chestName + "_particle") + ",";
        }
        return "";
    }

    private static String bedParticle(String bedColor) {
        if (EnhancedBlockEntities.CONFIG.experimentalBeds) {
            return ResourceUtil.kv("particle", "block/" + bedColor + "_bed_particle") + ",";
        }
        return "";
    }

    private static String signParticle(String signName) {
        if (EnhancedBlockEntities.CONFIG.experimentalSigns) {
            return ResourceUtil.kv("particle", "block/" + signName + "_particle") + ",";
        }
        return "";
    }

    private static void addBlockState(class_2960 id, TemplateProvider.TemplateApplyingFunction vars, EBEPack pack) {
        pack.addTemplateResource(class_2960.method_60655((String)id.method_12836(), (String)("blockstates/" + id.method_12832() + ".json")), t -> t.load("blockstate/base.json", d -> d.def("vars", vars)));
    }

    public static void addChestBlockStates(String chestName, EBEPack pack) {
        ResourceUtil.addBlockState(class_2960.method_60654((String)chestName), t0 -> ResourceUtil.list(ResourceUtil.variantHFacing(t0, "type=single,facing=", "builtin:" + chestName + "_center"), ResourceUtil.variantHFacing(t0, "type=left,facing=", "builtin:" + chestName + "_left"), ResourceUtil.variantHFacing(t0, "type=right,facing=", "builtin:" + chestName + "_right")), pack);
    }

    public static void addSingleChestOnlyBlockStates(String chestName, EBEPack pack) {
        ResourceUtil.addBlockState(class_2960.method_60654((String)chestName), t0 -> ResourceUtil.list(ResourceUtil.variantHFacing(t0, "facing=", "builtin:" + chestName + "_center")), pack);
    }

    public static void addParentModel(String parent, class_2960 id, EBEPack pack) {
        pack.addTemplateResource(class_2960.method_60655((String)id.method_12836(), (String)("models/" + id.method_12832() + ".json")), t -> "{" + ResourceUtil.kv("parent", parent) + "}");
    }

    public static void addParentTexModel(String parent, String textures, class_2960 id, EBEPack pack) {
        pack.addTemplateResource(class_2960.method_60655((String)id.method_12836(), (String)("models/" + id.method_12832() + ".json")), t -> t.load("model/parent_and_tex.json", d -> d.def("parent", parent).def("textures", textures)));
    }

    public static void addSignTypeModels(String signType, EBEPack pack) {
        String signName = signType + "_sign";
        String signTex = "entity/signs/" + signType;
        ResourceUtil.addRotation16Models(ResourceUtil.signParticle(signName) + ResourceUtil.kv("sign", signTex), "block/template_sign", "block/" + signName, ResourceUtil::signAOSuffix, pack);
        String hangingTexDef = ResourceUtil.list(ResourceUtil.kv("sign", "entity/signs/hanging/" + signType), ResourceUtil.kv("particle", "block/particle_hanging_sign_" + signType));
        ResourceUtil.addRotation16Models(hangingTexDef, "block/template_hanging_sign", "block/" + signType + "_hanging_sign", ResourceUtil::signAOSuffix, pack);
        ResourceUtil.addRotation16Models(hangingTexDef, "block/template_hanging_sign_attached", "block/" + signType + "_hanging_sign_attached", ResourceUtil::signAOSuffix, pack);
        ResourceUtil.addParentTexModel(ResourceUtil.signAOSuffix("block/template_wall_sign"), ResourceUtil.signParticle(signName) + ResourceUtil.kv("sign", signTex), class_2960.method_60654((String)("block/" + signType + "_wall_sign")), pack);
        ResourceUtil.addParentTexModel(ResourceUtil.signAOSuffix("block/template_wall_hanging_sign"), hangingTexDef, class_2960.method_60654((String)("block/" + signType + "_wall_hanging_sign")), pack);
    }

    public static void addRotation16Models(String textures, String templatePrefix, String modelPrefix, Function<String, String> suffix, EBEPack pack) {
        ResourceUtil.addParentTexModel(suffix.apply(templatePrefix + "_0"), textures, class_2960.method_60654((String)(modelPrefix + "_0")), pack);
        ResourceUtil.addParentTexModel(suffix.apply(templatePrefix + "_22_5"), textures, class_2960.method_60654((String)(modelPrefix + "_22_5")), pack);
        ResourceUtil.addParentTexModel(suffix.apply(templatePrefix + "_45"), textures, class_2960.method_60654((String)(modelPrefix + "_45")), pack);
        ResourceUtil.addParentTexModel(suffix.apply(templatePrefix + "_67_5"), textures, class_2960.method_60654((String)(modelPrefix + "_67_5")), pack);
    }

    private static String signAOSuffix(String model) {
        if (EnhancedBlockEntities.CONFIG.signAO) {
            model = (String)model + "_ao";
        }
        return model;
    }

    public static void addSignBlockStates(String signName, String wallSignName, EBEPack pack) {
        ResourceUtil.addBlockState(class_2960.method_60654((String)signName), t -> ResourceUtil.variantRotation16(t, "rotation=", "block/" + signName), pack);
        ResourceUtil.addBlockState(class_2960.method_60654((String)wallSignName), t -> ResourceUtil.variantHFacing(t, "facing=", "block/" + wallSignName), pack);
    }

    public static void addHangingSignBlockStates(String signName, String wallSignName, EBEPack pack) {
        ResourceUtil.addBlockState(class_2960.method_60654((String)signName), t -> ResourceUtil.list(ResourceUtil.variantRotation16(t, "attached=false,rotation=", "block/" + signName), ResourceUtil.variantRotation16(t, "attached=true,rotation=", "block/" + signName + "_attached")), pack);
        ResourceUtil.addBlockState(class_2960.method_60654((String)wallSignName), t -> ResourceUtil.variantHFacing(t, "facing=", "block/" + wallSignName), pack);
    }

    public static void addBellBlockState(EBEPack pack) {
        ResourceUtil.addBlockState(class_2960.method_60654((String)"bell"), t -> {
            DelimitedAppender vars = new DelimitedAppender(",");
            for (class_2350 dir : EBEUtil.HORIZONTAL_DIRECTIONS) {
                int rot = EBEUtil.angle(dir) + 90;
                vars.append(ResourceUtil.variantY(t, "attachment=double_wall,facing=" + dir.method_10151(), "builtin:bell_between_walls", rot)).append(ResourceUtil.variantY(t, "attachment=ceiling,facing=" + dir.method_10151(), "builtin:bell_ceiling", rot + 90)).append(ResourceUtil.variantY(t, "attachment=floor,facing=" + dir.method_10151(), "builtin:bell_floor", rot + 90)).append(ResourceUtil.variantY(t, "attachment=single_wall,facing=" + dir.method_10151(), "builtin:bell_wall", rot));
            }
            return vars.get();
        }, pack);
    }

    public static void addBedModels(class_1767 bedColor, EBEPack pack) {
        String color = bedColor.method_7792();
        ResourceUtil.addParentTexModel(ResourceUtil.bedAOSuffix("block/template_bed_head"), ResourceUtil.bedParticle(color) + ResourceUtil.kv("bed", "entity/bed/" + color), class_2960.method_60654((String)("block/" + color + "_bed_head")), pack);
        ResourceUtil.addParentTexModel(ResourceUtil.bedAOSuffix("block/template_bed_foot"), ResourceUtil.bedParticle(color) + ResourceUtil.kv("bed", "entity/bed/" + color), class_2960.method_60654((String)("block/" + color + "_bed_foot")), pack);
        ResourceUtil.addBedItemDefinition(color, pack);
    }

    public static void addBedBlockState(class_1767 bedColor, EBEPack pack) {
        String color = bedColor.method_7792();
        ResourceUtil.addBlockState(class_2960.method_60654((String)(color + "_bed")), t -> {
            DelimitedAppender vars = new DelimitedAppender(",");
            for (class_2350 dir : EBEUtil.HORIZONTAL_DIRECTIONS) {
                int rot = EBEUtil.angle(dir) + 180;
                vars.append(ResourceUtil.variantY(t, "part=head,facing=" + dir.method_10151(), "block/" + String.valueOf(bedColor) + "_bed_head", rot)).append(ResourceUtil.variantY(t, "part=foot,facing=" + dir.method_10151(), "block/" + String.valueOf(bedColor) + "_bed_foot", rot));
            }
            return vars.get();
        }, pack);
    }

    private static String bedAOSuffix(String model) {
        if (EnhancedBlockEntities.CONFIG.bedAO) {
            model = (String)model + "_ao";
        }
        return model;
    }

    public static void addShulkerBoxModels(@Nullable class_1767 color, EBEPack pack) {
        String texture = color != null ? "entity/shulker/shulker_" + color.method_7792() : "entity/shulker/shulker";
        String shulkerBoxStr = color != null ? color.method_7792() + "_shulker_box" : "shulker_box";
        String particle = "block/" + shulkerBoxStr;
        ResourceUtil.addParentTexModel("block/template_shulker_box", ResourceUtil.list(ResourceUtil.kv("shulker", texture), ResourceUtil.kv("particle", particle)), class_2960.method_60654((String)("block/" + shulkerBoxStr)), pack);
        ResourceUtil.addParentTexModel("block/template_shulker_box_bottom", ResourceUtil.list(ResourceUtil.kv("shulker", texture), ResourceUtil.kv("particle", particle)), class_2960.method_60654((String)("block/" + shulkerBoxStr + "_bottom")), pack);
        ResourceUtil.addParentTexModel("block/template_shulker_box_lid", ResourceUtil.list(ResourceUtil.kv("shulker", texture), ResourceUtil.kv("particle", particle)), class_2960.method_60654((String)("block/" + shulkerBoxStr + "_lid")), pack);
    }

    public static void addShulkerBoxBlockStates(@Nullable class_1767 color, EBEPack pack) {
        String shulkerBoxStr = color != null ? color.method_7792() + "_shulker_box" : "shulker_box";
        ResourceUtil.addBlockState(class_2960.method_60654((String)shulkerBoxStr), t -> {
            DelimitedAppender vars = new DelimitedAppender(",");
            vars.append(ResourceUtil.variant(t, "facing=up", "builtin:" + shulkerBoxStr)).append(ResourceUtil.variantXY(t, "facing=down", "builtin:" + shulkerBoxStr, 180, 0));
            for (class_2350 dir : EBEUtil.HORIZONTAL_DIRECTIONS) {
                int rot = EBEUtil.angle(dir) + 180;
                vars.append(ResourceUtil.variantXY(t, "facing=" + dir.method_10151(), "builtin:" + shulkerBoxStr, 90, rot));
            }
            return vars.get();
        }, pack);
    }

    public static void addDecoratedPotBlockState(EBEPack pack) {
        ResourceUtil.addBlockState(class_2960.method_60654((String)"decorated_pot"), t -> ResourceUtil.variantHFacing(t, "facing=", "builtin:decorated_pot"), pack);
    }

    public static void addDecoratedPotPatternModels(class_5321<class_9766> patternKey, EBEPack pack) {
        for (class_2350 dir : EBEUtil.HORIZONTAL_DIRECTIONS) {
            ResourceUtil.addParentTexModel("block/template_pottery_pattern_" + dir.method_10151(), ResourceUtil.kv("pattern", class_4722.method_49341(patternKey).method_24147().toString()), class_2960.method_60654((String)("block/" + patternKey.method_29177().method_12832() + "_" + dir.method_10151())), pack);
        }
    }

    public static void resetBasePack() {
        BASE_PACK = new EBEPack(EBEUtil.id("base_resources"), EnhancedBlockEntities.TEMPLATE_LOADER);
    }

    public static void resetTopLevelPack() {
        TOP_LEVEL_PACK = new EBEPack(EBEUtil.id("top_level_resources"), EnhancedBlockEntities.TEMPLATE_LOADER);
    }

    public static EBEPack getBasePack() {
        return BASE_PACK;
    }

    public static EBEPack getTopLevelPack() {
        return TOP_LEVEL_PACK;
    }

    public static EBEPack getPackForCompat() {
        if (EnhancedBlockEntities.CONFIG.forceResourcePackCompat) {
            return ResourceUtil.getTopLevelPack();
        }
        return ResourceUtil.getBasePack();
    }

    public static void dumpModAssets(Path dest) throws IOException {
        List roots = FabricLoader.getInstance().getModContainer("enhancedblockentities").map(ModContainer::getRootPaths).orElse(List.of());
        for (Path root : roots) {
            Stream<Path> sourceAssets = Files.walk(root.resolve("assets"), new FileVisitOption[0]);
            for (Path asset : sourceAssets.collect(Collectors.toSet())) {
                CopyOption[] copyOptionArray;
                if (Files.isDirectory(asset, new LinkOption[0])) continue;
                Path out = dest.resolve(root.relativize(asset));
                if (!Files.exists(out.getParent(), new LinkOption[0])) {
                    Files.createDirectories(out.getParent(), new FileAttribute[0]);
                }
                if (Files.exists(out, new LinkOption[0])) {
                    CopyOption[] copyOptionArray2 = new CopyOption[1];
                    copyOptionArray = copyOptionArray2;
                    copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                } else {
                    copyOptionArray = new CopyOption[]{};
                }
                Files.copy(asset, out, copyOptionArray);
            }
        }
    }

    public static void dumpAllPacks(Path dest) throws IOException {
        ResourceUtil.getBasePack().dump(dest);
        ResourceUtil.getTopLevelPack().dump(dest);
        ResourceUtil.dumpModAssets(dest);
    }

    private static /* synthetic */ ResourceUtil[] $values() {
        return new ResourceUtil[0];
    }

    static {
        $VALUES = ResourceUtil.$values();
        ResourceUtil.resetBasePack();
        ResourceUtil.resetTopLevelPack();
    }

    private static class DelimitedAppender {
        private final StringBuilder builder = new StringBuilder();
        private final CharSequence delimiter;

        private DelimitedAppender(CharSequence delimiter) {
            this.delimiter = delimiter;
        }

        public DelimitedAppender append(CharSequence seq) {
            if (!this.builder.isEmpty()) {
                this.builder.append(this.delimiter);
            }
            this.builder.append(seq);
            return this;
        }

        public String get() {
            return this.builder.toString();
        }
    }
}

