/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.model;

import foundationgames.enhancedblockentities.util.DateUtil;
import foundationgames.enhancedblockentities.util.duck.AppearanceStateHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

public abstract class ModelSelector {
    private static final List<ModelSelector> REGISTRY = new ArrayList<ModelSelector>();
    public static final ModelSelector STATE_HOLDER_SELECTOR;
    public static final ModelSelector CHEST;
    public static final ModelSelector CHEST_WITH_CHRISTMAS;
    public static final ModelSelector BELL;
    public static final ModelSelector SHULKER_BOX;
    public final int id = REGISTRY.size();
    public final int displayedModelCount;

    public int getParticleModelIndex() {
        return 0;
    }

    public abstract void writeModelIndices(class_1920 var1, class_2680 var2, class_2338 var3, Supplier<class_5819> var4, int[] var5);

    public ModelSelector(int displayedModelCount) {
        this.displayedModelCount = displayedModelCount;
        REGISTRY.add(this);
    }

    public ModelSelector() {
        this(1);
    }

    public static ModelSelector fromId(int id) {
        return REGISTRY.get(id);
    }

    static {
        CHEST = STATE_HOLDER_SELECTOR = new ModelSelector(){

            @Override
            public void writeModelIndices(class_1920 view, class_2680 state, class_2338 pos, Supplier<class_5819> rand, int[] indices) {
                class_2586 class_25862 = view.method_8321(pos);
                if (class_25862 instanceof AppearanceStateHolder) {
                    AppearanceStateHolder stateHolder = (AppearanceStateHolder)class_25862;
                    indices[0] = stateHolder.getModelState();
                    return;
                }
                indices[0] = 0;
            }
        };
        CHEST_WITH_CHRISTMAS = new ModelSelector(){

            @Override
            public int getParticleModelIndex() {
                return DateUtil.isChristmas() ? 2 : 0;
            }

            @Override
            public void writeModelIndices(class_1920 view, class_2680 state, class_2338 pos, Supplier<class_5819> rand, int[] indices) {
                class_2586 class_25862 = view.method_8321(pos);
                if (class_25862 instanceof AppearanceStateHolder) {
                    AppearanceStateHolder stateHolder = (AppearanceStateHolder)class_25862;
                    indices[0] = stateHolder.getModelState() + this.getParticleModelIndex();
                    return;
                }
                indices[0] = this.getParticleModelIndex();
            }
        };
        BELL = STATE_HOLDER_SELECTOR;
        SHULKER_BOX = STATE_HOLDER_SELECTOR;
    }
}

