/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.elementa.constraints.animation;

import dev.dediamondpro.resourcify.libs.elementa.UIComponent;
import dev.dediamondpro.resourcify.libs.elementa.constraints.ColorConstraint;
import dev.dediamondpro.resourcify.libs.elementa.constraints.ConstraintType;
import dev.dediamondpro.resourcify.libs.elementa.constraints.animation.AnimationComponent;
import dev.dediamondpro.resourcify.libs.elementa.constraints.animation.AnimationStrategy;
import dev.dediamondpro.resourcify.libs.elementa.constraints.resolution.ConstraintVisitor;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B/\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR*\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\u00020\u00028\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010#\u001a\u0004\u0018\u00010\u00108\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0017\u0010\t\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\t\u0010)\u001a\u0004\b*\u0010+R\u0017\u0010\b\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\b\u0010)\u001a\u0004\b,\u0010+R\"\u0010.\u001a\u00020-8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u00064"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/ColorAnimationComponent;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/AnimationComponent;", "Ljava/awt/Color;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/ColorConstraint;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/AnimationStrategy;", "strategy", "", "totalFrames", "oldConstraint", "newConstraint", "delay", "<init>", "(Lgg/essential/elementa/constraints/animation/AnimationStrategy;ILgg/essential/elementa/constraints/ColorConstraint;Lgg/essential/elementa/constraints/ColorConstraint;I)V", "", "animationFrame", "()V", "Ldev/dediamondpro/resourcify/libs/elementa/UIComponent;", "component", "getColorImpl", "(Lgg/essential/elementa/UIComponent;)Ljava/awt/Color;", "to", "(Lgg/essential/elementa/UIComponent;)Lgg/essential/elementa/constraints/animation/ColorAnimationComponent;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/resolution/ConstraintVisitor;", "visitor", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/ConstraintType;", "type", "visitImpl", "(Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;Lgg/essential/elementa/constraints/ConstraintType;)V", "kotlin.jvm.PlatformType", "cachedValue", "Ljava/awt/Color;", "getCachedValue", "()Ljava/awt/Color;", "setCachedValue", "(Ljava/awt/Color;)V", "constrainTo", "Ldev/dediamondpro/resourcify/libs/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "(Lgg/essential/elementa/UIComponent;)V", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/ColorConstraint;", "getNewConstraint", "()Lgg/essential/elementa/constraints/ColorConstraint;", "getOldConstraint", "", "recalculate", "Z", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "Elementa"})
public final class ColorAnimationComponent
extends AnimationComponent<Color>
implements ColorConstraint {
    @NotNull
    private final ColorConstraint oldConstraint;
    @NotNull
    private final ColorConstraint newConstraint;
    private Color cachedValue;
    private boolean recalculate;
    @Nullable
    private UIComponent constrainTo;

    public ColorAnimationComponent(@NotNull AnimationStrategy strategy, int totalFrames, @NotNull ColorConstraint oldConstraint, @NotNull ColorConstraint newConstraint, int delay2) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)oldConstraint, (String)"oldConstraint");
        Intrinsics.checkNotNullParameter((Object)newConstraint, (String)"newConstraint");
        super(strategy, totalFrames, delay2, null);
        this.oldConstraint = oldConstraint;
        this.newConstraint = newConstraint;
        this.cachedValue = Color.WHITE;
        this.recalculate = true;
    }

    @NotNull
    public final ColorConstraint getOldConstraint() {
        return this.oldConstraint;
    }

    @NotNull
    public final ColorConstraint getNewConstraint() {
        return this.newConstraint;
    }

    @Override
    public Color getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Color color) {
        this.cachedValue = color;
    }

    @Override
    public boolean getRecalculate() {
        return this.recalculate;
    }

    @Override
    public void setRecalculate(boolean bl) {
        this.recalculate = bl;
    }

    @Override
    @Nullable
    public UIComponent getConstrainTo() {
        return this.constrainTo;
    }

    @Override
    public void setConstrainTo(@Nullable UIComponent uIComponent) {
        this.constrainTo = uIComponent;
    }

    @Override
    @NotNull
    public Color getColorImpl(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Color startColor = this.oldConstraint.getColor(component2);
        Color endColor = this.newConstraint.getColor(component2);
        float percentComplete = this.getPercentComplete();
        float newR = (float)startColor.getRed() + (float)(endColor.getRed() - startColor.getRed()) * percentComplete;
        float newG = (float)startColor.getGreen() + (float)(endColor.getGreen() - startColor.getGreen()) * percentComplete;
        float newB = (float)startColor.getBlue() + (float)(endColor.getBlue() - startColor.getBlue()) * percentComplete;
        float newA = (float)startColor.getAlpha() + (float)(endColor.getAlpha() - startColor.getAlpha()) * percentComplete;
        return new Color(MathKt.roundToInt((float)newR), MathKt.roundToInt((float)newG), MathKt.roundToInt((float)newB), MathKt.roundToInt((float)newA));
    }

    @Override
    public void animationFrame() {
        super.animationFrame();
        this.oldConstraint.animationFrame();
        this.newConstraint.animationFrame();
    }

    @NotNull
    public ColorAnimationComponent to(@NotNull UIComponent component2) {
        ColorAnimationComponent colorAnimationComponent;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        ColorAnimationComponent $this$to_u24lambda_u240 = colorAnimationComponent = this;
        boolean bl = false;
        throw new UnsupportedOperationException("Constraint.to(UIComponent) is not available in this context!");
    }

    @Override
    public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type2) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.oldConstraint.visit(visitor, type2, false);
        this.newConstraint.visit(visitor, type2, false);
    }
}

