/*
 * Decompiled with CFR 0.152.
 */
package vertigo.unobtrusiveeffects;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import vertigo.unobtrusiveeffects.UnobtrusiveEffectsClient;

@Environment(value=EnvType.CLIENT)
public class Config {
    private static final String SEPARATOR = " = ";
    private static final String DISABLE_FIRE_OVERLAY = "disableFireOverlay";
    private static final String SWIRL_CULLING_DISTANCE = "swirlCullingDistance";
    public boolean disableFireOverlay = true;
    public float swirlCullingDistance = 2.5f;

    public Config() {
        if (!this.read()) {
            this.write();
        }
    }

    public void write() {
        File file = this.getFile();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write("disableFireOverlay = " + this.disableFireOverlay + System.lineSeparator());
            writer.write("swirlCullingDistance = " + this.swirlCullingDistance);
        }
        catch (IOException e) {
            UnobtrusiveEffectsClient.LOGGER.error("Failed to write config ({})", (Object)file.getPath());
        }
    }

    public boolean read() {
        File file = this.getFile();
        if (!file.exists()) {
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] segments = line.split(SEPARATOR);
                if (segments.length != 2 || segments[0].isEmpty() || segments[1].isEmpty()) continue;
                switch (segments[0]) {
                    case "disableFireOverlay": {
                        this.disableFireOverlay = segments[1].equals("true");
                        break;
                    }
                    case "swirlCullingDistance": {
                        try {
                            this.swirlCullingDistance = Float.parseFloat(segments[1]);
                        }
                        catch (NumberFormatException e) {}
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            UnobtrusiveEffectsClient.LOGGER.error("Failed to read config ({})", (Object)file.getPath());
        }
        return true;
    }

    private File getFile() {
        return FabricLoader.getInstance().getGameDir().resolve("config").resolve("unobtrusive-effects.ini").toFile();
    }
}

