/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_1297;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import pigcart.particlerain.ParticleRainClient;
import pigcart.particlerain.config.ModConfig;

public final class WeatherParticleManager {
    public static int particleCount;
    public static int fogCount;
    private static final class_2338.class_2339 pos;

    private static void spawnParticle(class_638 level, class_6880<class_1959> biome, double x, double y, double z) {
        class_1959.class_1963 precipitation;
        if (particleCount > ModConfig.CONFIG.perf.maxParticleAmount) {
            return;
        }
        if (!ModConfig.CONFIG.spawn.canSpawnAboveClouds && y > (double)ModConfig.CONFIG.spawn.cloudHeight) {
            y = ModConfig.CONFIG.spawn.cloudHeight;
        }
        if (ModConfig.CONFIG.effect.doFogParticles && level.field_9229.method_43057() < ModConfig.CONFIG.fog.density) {
            level.method_8406((class_2394)ParticleRainClient.FOG, x, y, z, 0.0, 0.0, 0.0);
        }
        class_2338.class_2339 getPrecipitationFromBlockPos = ModConfig.CONFIG.spawn.useHeightmapTemp ? level.method_8598(class_2902.class_2903.field_13197, (class_2338)pos) : pos;
        class_1959.class_1963 class_19632 = precipitation = ModConfig.CONFIG.spawn.doOverrideWeather ? ModConfig.CONFIG.spawn.overrideWeather : ((class_1959)biome.comp_349()).method_48162((class_2338)getPrecipitationFromBlockPos, level.method_8615());
        if (precipitation == class_1959.class_1963.field_9382) {
            int height;
            if (ModConfig.CONFIG.effect.doGroundFogParticles && fogCount < ModConfig.CONFIG.groundFog.density && (height = level.method_8624(class_2902.class_2903.field_13197, (int)x, (int)z)) <= ModConfig.CONFIG.groundFog.maxSpawnHeight && height >= ModConfig.CONFIG.groundFog.minSpawnHeight && level.method_8316(class_2338.method_49637((double)x, (double)(height - 1), (double)z)).method_15769()) {
                level.method_8406((class_2394)ParticleRainClient.GROUND_FOG, x, (double)((float)height + level.field_9229.method_43057()), z, 0.0, 0.0, 0.0);
            }
            if (ModConfig.CONFIG.effect.doRainParticles && level.field_9229.method_43057() < ModConfig.CONFIG.rain.density) {
                level.method_8406((class_2394)ParticleRainClient.RAIN, x, y, z, 0.0, 0.0, 0.0);
            }
        } else if (precipitation == class_1959.class_1963.field_9383 && ModConfig.CONFIG.effect.doSnowParticles) {
            if (level.field_9229.method_43057() < ModConfig.CONFIG.snow.density) {
                level.method_8406((class_2394)ParticleRainClient.SNOW, x, y, z, 0.0, 0.0, 0.0);
            }
        } else if (WeatherParticleManager.doesThisBlockHaveDustBlowing(precipitation, level, class_2338.method_49637((double)x, (double)y, (double)z), biome)) {
            if (ModConfig.CONFIG.dust.spawnOnGround) {
                y = level.method_8624(class_2902.class_2903.field_13197, (int)x, (int)z);
            }
            if (ModConfig.CONFIG.effect.doDustParticles && level.field_9229.method_43057() < ModConfig.CONFIG.dust.density) {
                level.method_8406((class_2394)ParticleRainClient.DUST, x, y, z, 0.0, 0.0, 0.0);
            }
            if (ModConfig.CONFIG.effect.doShrubParticles && level.field_9229.method_43057() < ModConfig.CONFIG.shrub.density) {
                level.method_8406((class_2394)ParticleRainClient.SHRUB, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void tick(class_638 level, class_1297 entity) {
        if (level.method_8419() || ModConfig.CONFIG.compat.alwaysRaining) {
            int density = level.method_8546() ? (ModConfig.CONFIG.compat.alwaysRaining ? ModConfig.CONFIG.perf.particleStormDensity : (int)((float)ModConfig.CONFIG.perf.particleStormDensity * level.method_8430(0.0f))) : (ModConfig.CONFIG.compat.alwaysRaining ? ModConfig.CONFIG.perf.particleDensity : (int)((float)ModConfig.CONFIG.perf.particleDensity * level.method_8430(0.0f)));
            class_5819 rand = class_5819.method_43047();
            for (int pass = 0; pass < density; ++pass) {
                float theta = (float)(Math.PI * 2 * (double)rand.method_43057());
                float phi = (float)Math.acos(2.0f * rand.method_43057() - 1.0f);
                double x = (double)((float)ModConfig.CONFIG.perf.particleRadius * class_3532.method_15374((float)phi)) * Math.cos(theta);
                double y = (double)((float)ModConfig.CONFIG.perf.particleRadius * class_3532.method_15374((float)phi)) * Math.sin(theta);
                double z = (float)ModConfig.CONFIG.perf.particleRadius * class_3532.method_15362((float)phi);
                pos.method_10102(x + entity.method_23317(), y + entity.method_23318(), z + entity.method_23321());
                if (level.method_8624(class_2902.class_2903.field_13197, pos.method_10263(), pos.method_10260()) > pos.method_10264()) continue;
                WeatherParticleManager.spawnParticle(level, (class_6880<class_1959>)level.method_23753((class_2338)pos), (float)pos.method_10263() + rand.method_43057(), (float)pos.method_10264() + rand.method_43057(), (float)pos.method_10260() + rand.method_43057());
            }
        }
    }

    @Nullable
    public static class_3414 getBiomeSound(class_2338 blockPos, boolean above) {
        class_1959.class_1963 precipitation;
        class_6880 biome = class_310.method_1551().field_1687.method_23753(blockPos);
        class_1959.class_1963 class_19632 = precipitation = ModConfig.CONFIG.spawn.doOverrideWeather ? ModConfig.CONFIG.spawn.overrideWeather : ((class_1959)biome.comp_349()).method_48162(blockPos, class_310.method_1551().field_1687.method_8615());
        if (precipitation == class_1959.class_1963.field_9382 && ModConfig.CONFIG.sound.doRainSounds) {
            return above ? class_3417.field_15020 : class_3417.field_14946;
        }
        if (precipitation == class_1959.class_1963.field_9383 && ModConfig.CONFIG.sound.doSnowSounds) {
            return above ? ParticleRainClient.WEATHER_SNOW_ABOVE : ParticleRainClient.WEATHER_SNOW;
        }
        if (WeatherParticleManager.doesThisBlockHaveDustBlowing(precipitation, class_310.method_1551().field_1687, blockPos, (class_6880<class_1959>)biome) && ModConfig.CONFIG.sound.doSandSounds) {
            return above ? ParticleRainClient.WEATHER_SANDSTORM_ABOVE : ParticleRainClient.WEATHER_SANDSTORM;
        }
        return null;
    }

    public static boolean doesThisBlockHaveDustBlowing(class_1959.class_1963 precipitation, class_638 level, class_2338 blockPos, class_6880<class_1959> biome) {
        boolean matchesTag = false;
        for (int i = 0; i < ModConfig.CONFIG.spawn.dustyBlockTags.size(); ++i) {
            if (!level.method_8320(level.method_8598(class_2902.class_2903.field_13197, blockPos).method_10074()).method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)ModConfig.CONFIG.spawn.dustyBlockTags.get(i))))) continue;
            matchesTag = true;
            break;
        }
        return precipitation == class_1959.class_1963.field_9384 && matchesTag && (double)((class_1959)biome.comp_349()).method_8712() > 0.25;
    }

    public static boolean canHostStreaks(class_2680 state) {
        return state.method_26164(class_3481.field_15490) || state.method_26164(class_3481.field_33715) || state.method_26164(ConventionalBlockTags.GLASS_PANES);
    }

    public static void resetParticleCount() {
        particleCount = 0;
        fogCount = 0;
    }

    static {
        pos = new class_2338.class_2339();
    }
}

