/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import java.awt.Color;
import java.io.IOException;
import net.minecraft.class_1011;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.config.ModConfig;

public class WeatherBlockManager {
    static class_1011 puddleMap;
    public static int puddleThreshold;
    public static int puddleTargetLevel;
    public static int ticksUntilPuddleUpdate;

    public static int getPuddleLevel(int x, int z) {
        x = class_3532.method_15382((int)(x % puddleMap.method_4307()));
        z = class_3532.method_15382((int)(z % puddleMap.method_4323()));
        int pixel = puddleMap.method_61940(x, z);
        Color color = new Color(pixel);
        return color.getBlue();
    }

    public static boolean hasPuddle(class_638 level, class_2338 puddlePos) {
        return ((class_1959)level.method_23753(puddlePos).comp_349()).method_48162(puddlePos, level.method_8615()) == class_1959.class_1963.field_9382 && WeatherBlockManager.isExposed(level, puddlePos) && WeatherBlockManager.getPuddleLevel(puddlePos.method_10263(), puddlePos.method_10260()) < puddleThreshold && level.method_8320(puddlePos.method_10074()).method_26206((class_1922)level, puddlePos, class_2350.field_11033) && level.method_8320(puddlePos.method_10074()).method_26234((class_1922)level, puddlePos.method_10074()) && level.method_8320(puddlePos.method_10095().method_10074()).method_51367() && level.method_8320(puddlePos.method_10095()).method_26227().method_15769() && level.method_8320(puddlePos.method_10078().method_10074()).method_51367() && level.method_8320(puddlePos.method_10078()).method_26227().method_15769() && level.method_8320(puddlePos.method_10072().method_10074()).method_51367() && level.method_8320(puddlePos.method_10072()).method_26227().method_15769() && level.method_8320(puddlePos.method_10067().method_10074()).method_51367() && level.method_8320(puddlePos.method_10067()).method_26227().method_15769();
    }

    public static boolean isExposed(class_638 level, class_2338 blockPos) {
        class_2338 heightmapPos = level.method_8598(class_2902.class_2903.field_13197, blockPos);
        if (level.method_8311(blockPos)) {
            if (heightmapPos.method_10264() > blockPos.method_10264()) {
                return !level.method_8320(heightmapPos.method_10074()).method_26234((class_1922)level, heightmapPos);
            }
            return true;
        }
        return false;
    }

    public static void tick(class_638 level) {
        if (ModConfig.CONFIG.effect.doPuddles) {
            if (ticksUntilPuddleUpdate-- == 0) {
                ticksUntilPuddleUpdate = ModConfig.CONFIG.puddle.updateDelay;
                if (puddleThreshold != puddleTargetLevel) {
                    if (puddleThreshold < puddleTargetLevel) {
                        if ((puddleThreshold += ModConfig.CONFIG.puddle.updateStep) > puddleTargetLevel) {
                            puddleThreshold = puddleTargetLevel;
                        }
                    } else if ((puddleThreshold -= ModConfig.CONFIG.puddle.updateStep) < puddleTargetLevel) {
                        puddleThreshold = puddleTargetLevel;
                    }
                    WeatherBlockManager.setLevelDirty(level);
                }
                puddleTargetLevel = level.method_8419() ? (level.method_8546() ? ModConfig.CONFIG.puddle.stormLevel : ModConfig.CONFIG.puddle.rainLevel) : 0;
            }
        } else if (puddleThreshold != 0) {
            puddleThreshold = 0;
            WeatherBlockManager.setLevelDirty(level);
        }
    }

    public static void setLevelDirty(class_638 level) {
        int renderDistance = (Integer)class_310.method_1551().field_1690.method_42503().method_41753();
        class_1923 playerPos = class_310.method_1551().field_1724.method_31476();
        class_310.method_1551().field_1769.method_62219(playerPos.field_9181 - renderDistance, level.method_32891(), playerPos.field_9180 - renderDistance, playerPos.field_9181 + renderDistance, level.method_31597(), playerPos.field_9180 + renderDistance);
    }

    static {
        try {
            puddleMap = TextureUtil.loadTexture(class_2960.method_60655((String)"particlerain", (String)"textures/puddles.png"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        puddleThreshold = 0;
        puddleTargetLevel = 0;
        ticksUntilPuddleUpdate = 0;
    }
}

