/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.Components;
import mod.crend.autohud.render.AutoHudRenderLayer;
import mod.crend.autohud.render.AutoHudRenderer;
import mod.crend.libbamboo.render.CustomFramebufferRenderer;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_6880;

public class ComponentRenderer {
    public static ComponentRenderer HOTBAR = ComponentRenderer.builder(Components.Hotbar).fade().move().doRender(() -> Components.Hotbar.shouldRender() || AutoHudRenderer.shouldRenderHotbarItems()).build();
    public static ComponentRenderer TOOLTIP = ComponentRenderer.of(Components.Tooltip);
    public static ComponentRenderer HOTBAR_ITEMS = ComponentRenderer.builder(Components.Hotbar).fade().isActive(() -> Components.Hotbar.isActive() && AutoHud.config.animationFade()).doRender(AutoHudRenderer::shouldRenderHotbarItems).withCustomFramebuffer(true).maximumFade(AutoHud.config::getHotbarItemsMaximumFade).beginRender((class_332 context) -> AutoHudRenderLayer.FADE_MODE.postRender(Components.Hotbar, (class_332)context)).build();
    public static ComponentRenderer EXPERIENCE_BAR = ComponentRenderer.of(Components.ExperienceBar);
    public static ComponentRenderer EXPERIENCE_LEVEL = ComponentRenderer.of(Components.ExperienceLevel);
    public static ComponentRenderer EXPERIENCE_BAR_FORGE = ComponentRenderer.builder(Components.ExperienceBar).move().fade().doRender(() -> Components.ExperienceBar.shouldRender() || Components.ExperienceLevel.shouldRender()).build();
    public static ComponentRenderer EXPERIENCE_LEVEL_FORGE = ComponentRenderer.builder(Components.ExperienceLevel).move().fade().beginRender((class_332 context) -> {
        AutoHudRenderLayer.MOVE_MODE.postRender(Components.ExperienceBar, (class_332)context);
        AutoHudRenderLayer.MOVE_MODE.preRender(Components.ExperienceLevel, (class_332)context);
    }).endRender((class_332 context) -> {
        AutoHudRenderLayer.MOVE_MODE.postRender(Components.ExperienceLevel, (class_332)context);
        AutoHudRenderLayer.MOVE_MODE.preRender(Components.ExperienceBar, (class_332)context);
    }).build();
    public static ComponentRenderer ARMOR = ComponentRenderer.of(Components.Armor);
    public static ComponentRenderer ARMOR_FADE = ComponentRenderer.builder(Components.Armor).fade().withCustomFramebuffer(true).build();
    public static ComponentRenderer HEALTH = ComponentRenderer.of(Components.Health);
    public static ComponentRenderer HUNGER = ComponentRenderer.of(Components.Hunger);
    public static ComponentRenderer AIR = ComponentRenderer.of(Components.Air);
    public static ComponentRenderer MOUNT_HEALTH = ComponentRenderer.of(Components.MountHealth);
    public static ComponentRenderer MOUNT_JUMP_BAR = ComponentRenderer.of(Components.MountJumpBar);
    public static ComponentRenderer SCOREBOARD = ComponentRenderer.of(Components.Scoreboard);
    public static ComponentRenderer CROSSHAIR = ComponentRenderer.builder(Components.Crosshair).withCustomFramebuffer(false).beginRender((class_332 context) -> {
        RenderSystem.defaultBlendFunc();
        AutoHudRenderLayer.FADE_MODE.preRender(Components.Crosshair, (class_332)context);
    }).endRender((class_332 context) -> {
        AutoHudRenderLayer.FADE_MODE.postRender(Components.Crosshair, (class_332)context);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
    }).build();
    public static ComponentRenderer CHAT = ComponentRenderer.of(Components.Chat);
    public static ComponentRenderer BOSS_BAR = ComponentRenderer.of(Components.BossBar);
    public static ComponentRenderer ACTION_BAR = ComponentRenderer.of(Components.ActionBar);
    public static ComponentRenderer CHAT_MESSAGE_INDICATOR = ComponentRenderer.of(Components.ChatIndicator);
    static Map<class_2960, ComponentRenderer> statusEffectComponents = new HashMap<class_2960, ComponentRenderer>();
    private final Component component;
    private final Supplier<Boolean> isActive;
    private final Supplier<Boolean> doRender;
    private final Consumer<class_332> beginRender;
    private final Consumer<class_332> endRender;

    public static void registerStatusEffectComponent(Component component) {
        statusEffectComponents.put(component.identifier, ComponentRenderer.of(component));
    }

    public static ComponentRenderer getForStatusEffect(class_1293 instance) {
        return statusEffectComponents.get(Component.get((class_6880<class_1291>)instance.method_5579()).identifier);
    }

    public static ComponentRenderer getForStatusEffect(class_1058 sprite) {
        return statusEffectComponents.get(Objects.requireNonNull(Component.findBySprite((class_1058)sprite)).identifier);
    }

    public static Builder builder(Component component) {
        return new Builder(component);
    }

    public static ComponentRenderer of(Component component) {
        return ComponentRenderer.builder(component).move().fade().build();
    }

    private ComponentRenderer(Component component, Supplier<Boolean> isActive, Supplier<Boolean> doRender, Consumer<class_332> beginRender, Consumer<class_332> endRender) {
        this.component = component;
        this.isActive = isActive;
        this.doRender = doRender;
        this.beginRender = beginRender;
        this.endRender = endRender;
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public boolean doRender() {
        return this.doRender.get();
    }

    public void beginRender(class_332 context) {
        if (this.isActive()) {
            this.beginRender.accept(context);
        }
    }

    public void endRender(class_332 context) {
        if (this.isActive()) {
            this.endRender.accept(context);
        }
    }

    public void wrap(class_332 context, Runnable originalRenderCall) {
        this.wrap(context, originalRenderCall, originalRenderCall);
    }

    public void wrap(class_332 context, Runnable customRenderCall, Runnable originalRenderCall) {
        if (this.isActive()) {
            if (this.doRender()) {
                this.beginRender.accept(context);
                customRenderCall.run();
                this.endRender.accept(context);
            }
        } else {
            originalRenderCall.run();
        }
    }

    public void wrap(class_332 context, Consumer<class_332> originalRenderCall) {
        this.wrap(context, originalRenderCall, originalRenderCall);
    }

    public void wrap(class_332 context, Consumer<class_332> customRenderCall, Consumer<class_332> originalRenderCall) {
        this.wrap(context, () -> customRenderCall.accept(context), () -> originalRenderCall.accept(context));
    }

    public void beginFade(class_332 context) {
        if (this.isActive()) {
            AutoHudRenderLayer.FADE_MODE.preRender(this.component, context);
        }
    }

    public void endFade(class_332 context) {
        if (this.isActive()) {
            AutoHudRenderLayer.FADE_MODE.postRender(this.component, context);
        }
    }

    public static class Builder {
        private final Component component;
        private boolean fade = false;
        private boolean move = false;
        private boolean customFramebuffer = false;
        private boolean containedInMovedComponent = false;
        private Supplier<Float> maximumFade = null;
        private Supplier<Boolean> isActive = null;
        private Supplier<Boolean> doRender = null;
        private Consumer<class_332> beginRender = null;
        private Consumer<class_332> endRender = null;

        Builder(Component component) {
            this.component = component;
        }

        public Builder fade() {
            this.fade = true;
            return this;
        }

        public Builder move() {
            this.move = true;
            return this;
        }

        public Builder withCustomFramebuffer(boolean containedInMovedComponent) {
            this.customFramebuffer = true;
            this.containedInMovedComponent = containedInMovedComponent;
            return this;
        }

        public Builder maximumFade(Supplier<Float> maximumFade) {
            this.maximumFade = maximumFade;
            return this;
        }

        public Builder isActive(Supplier<Boolean> isActive) {
            this.isActive = isActive;
            return this;
        }

        public Builder doRender(Supplier<Boolean> doRender) {
            this.doRender = doRender;
            return this;
        }

        public Builder beginRender(Consumer<class_332> beginRender) {
            this.beginRender = beginRender;
            return this;
        }

        public Builder endRender(Consumer<class_332> endRender) {
            this.endRender = endRender;
            return this;
        }

        public ComponentRenderer build() {
            if (this.isActive == null) {
                this.isActive = this.component::isActive;
            }
            if (this.doRender == null) {
                this.doRender = this.component::shouldRender;
            }
            if (this.maximumFade == null) {
                this.maximumFade = () -> Float.valueOf((float)this.component.config.maximumFade());
            }
            AutoHudRenderLayer wrapper = this.move || !this.fade ? AutoHudRenderLayer.MOVE_MODE : AutoHudRenderLayer.FADE_MODE;
            if (this.beginRender == null) {
                this.beginRender = context -> wrapper.preRender(this.component, (class_332)context, this.maximumFade.get().floatValue());
            }
            if (this.endRender == null) {
                this.endRender = context -> wrapper.postRender(this.component, (class_332)context);
            }
            return new ComponentRenderer(this.component, this.isActive, this.doRender, this.customFramebuffer ? context -> {
                this.beginRender.accept((class_332)context);
                CustomFramebufferRenderer.init();
            } : this.beginRender, this.customFramebuffer ? this.getCustomFramebufferEndRender() : this.endRender);
        }

        private Consumer<class_332> getCustomFramebufferEndRender() {
            if (this.fade) {
                if (this.containedInMovedComponent) {
                    return context -> {
                        this.endRender.accept((class_332)context);
                        AutoHudRenderLayer.FADE_MODE_WITH_REVERSE_TRANSLATION.wrap(this.component, (class_332)context, this.maximumFade.get().floatValue(), () -> CustomFramebufferRenderer.draw((class_332)context));
                    };
                }
                return context -> {
                    this.endRender.accept((class_332)context);
                    AutoHudRenderLayer.FADE_MODE.wrap(this.component, (class_332)context, this.maximumFade.get().floatValue(), () -> CustomFramebufferRenderer.draw((class_332)context));
                };
            }
            return context -> {
                this.endRender.accept((class_332)context);
                CustomFramebufferRenderer.draw((class_332)context);
            };
        }
    }
}

