/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component.state;

import java.util.Objects;
import java.util.function.Supplier;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.state.ComponentState;

public class ValueComponentState<T>
extends ComponentState {
    protected T oldValue;
    protected Supplier<T> newValueSupplier;

    public ValueComponentState(Component component, Supplier<T> newValueSupplier, boolean updateEveryTick) {
        super(component, updateEveryTick);
        this.newValueSupplier = newValueSupplier;
        this.oldValue = newValueSupplier.get();
    }

    public ValueComponentState(Component component, Supplier<T> newValueSupplier) {
        this(component, newValueSupplier, false);
    }

    @Override
    public void update() {
        T newValue = this.newValueSupplier.get();
        if (this.doReveal(newValue)) {
            this.onUpdateReveal(newValue);
            this.component.revealCombined();
        }
        this.oldValue = newValue;
    }

    protected boolean doReveal(T newValue) {
        return !this.component.config.active() || this.component.config.onChange() && !Objects.equals(newValue, this.oldValue);
    }

    protected void onUpdateReveal(T newValue) {
    }
}

