/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component;

import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.Components;
import mod.crend.autohud.component.State;
import mod.crend.autohud.render.ComponentRenderer;
import net.minecraft.class_1293;
import net.minecraft.class_746;

public class Hud {
    private static boolean dynamic = false;
    private static boolean wasPeeking = false;
    private static State state = null;

    public static boolean actDynamic() {
        return dynamic || wasPeeking;
    }

    public static void disableDynamic() {
        dynamic = false;
        Component.revealAll();
        Components.ChatIndicator.hide();
    }

    public static void enableDynamic() {
        dynamic = true;
        Component.hideAll();
    }

    public static void toggleHud() {
        if (dynamic) {
            Hud.disableDynamic();
        } else {
            Hud.enableDynamic();
        }
    }

    public static void peekHud(boolean doPeek) {
        if (dynamic == doPeek) {
            Component.revealAll();
            Components.ChatIndicator.hide();
        } else if (doPeek != wasPeeking) {
            Component.hideAll();
        }
        wasPeeking = doPeek;
    }

    public static void registerState(class_746 player) {
        state = new State(player);
        wasPeeking = false;
    }

    public static void tickState(class_746 player) {
        state.tick(player);
    }

    public static void unregisterState() {
        state = null;
    }

    public static boolean shouldShowIcon(class_1293 instance) {
        ComponentRenderer renderer = ComponentRenderer.getForStatusEffect(instance);
        return !renderer.isActive() || renderer.doRender();
    }
}

