/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle_spawning;

import games.enchanted.blockplaceparticles.particle_spawning.ParticleCategory;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class SpawnParticlesUtil {
    public static boolean isParticleOutsideRenderDistance(@NotNull ParticleCategory particleCategory, class_2338 particlePos) {
        return SpawnParticlesUtil.isParticleOutsideRenderDistance(particleCategory, particlePos.method_10263(), particlePos.method_10264(), particlePos.method_10260());
    }

    public static boolean isParticleOutsideRenderDistance(@NotNull ParticleCategory particleCategory, double x, double y, double z) {
        double maxDistance;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        double distanceFromPlayer = MathHelpers.getDistanceBetweenPoints(player.method_23317() / 16.0, player.method_23318() / 16.0, player.method_23321() / 16.0, x / 16.0, y / 16.0, z / 16.0);
        return distanceFromPlayer >= (maxDistance = (double)Math.min(particleCategory.getMaxDistance(), (Integer)class_310.method_1551().field_1690.method_42503().method_41753()));
    }

    public static void spawnParticleInCircle(class_2394 particleOptions, class_638 level, class_243 center, int amount, float spread, float radius, float outwardVelocityMultiplier, float verticalVelocityBase, float verticalVelocityMultiplier) {
        float randomAngleOffset = (float)Math.toRadians(MathHelpers.randomBetween(0.0f, 360.0f));
        radius /= 2.0f;
        for (int i = 0; i < amount; ++i) {
            float progressRadians = (float)Math.toRadians((float)i / (float)amount * 360.0f) + randomAngleOffset;
            double distX = (double)radius * Math.cos(progressRadians) + (double)MathHelpers.randomBetween(-(spread / 2.0f), spread / 2.0f);
            double distZ = (double)radius * Math.sin(progressRadians) + (double)MathHelpers.randomBetween(-(spread / 2.0f), spread / 2.0f);
            double x = center.field_1352 + distX;
            double z = center.field_1350 + distZ;
            double distFromCenter = Math.max(Math.abs(distX), Math.abs(distZ));
            level.method_8406(particleOptions, x, center.field_1351, z, Math.clamp(distX, -1.0, 1.0) * (double)outwardVelocityMultiplier, (double)verticalVelocityBase + Math.abs((double)(radius + spread / 2.0f) - distFromCenter) * (double)verticalVelocityMultiplier, Math.clamp(distZ, -1.0, 1.0) * (double)outwardVelocityMultiplier);
        }
    }

    public static void spawnMostlyUpwardsMotionParticleOption(class_1937 level, class_2394 particleOptions, double xPos, double yPos, double zPos, double velocityIntensity) {
        level.method_8406(particleOptions, xPos, yPos, zPos, (level.field_9229.method_43058() - 0.5) * velocityIntensity * 0.4, Math.abs((level.field_9229.method_43058() - 0.25) * velocityIntensity) + 0.25, (level.field_9229.method_43058() - 0.5) * velocityIntensity * 0.4);
    }
}

