/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.shatter;

import games.enchanted.blockplaceparticles.particle.ModParticleRenderTypes;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import games.enchanted.blockplaceparticles.util.RenderingUtil;
import games.enchanted.blockplaceparticles.util.TextureHelpers;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class AbstractShatter
extends class_703 {
    protected final float slice0X;
    protected final float slice0Y;
    protected final float slice1X;
    protected final float slice1Y;
    protected final float uvScale;
    protected final float uvOffset;
    protected final boolean inverseSlicePositions;
    protected class_1058 sprite = TextureHelpers.getDebugSprite();

    protected AbstractShatter(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        int spriteWidth = this.sprite.method_45851().method_45807();
        int randomSize = MathHelpers.randomBetween(3, 5);
        int randomSizeThird = randomSize / 3;
        this.uvOffset = (float)MathHelpers.randomBetween(0, spriteWidth - randomSize) / (float)spriteWidth;
        this.uvScale = (float)randomSize / (float)spriteWidth;
        this.slice0X = (float)MathHelpers.randomBetween(1, randomSizeThird) / (float)randomSize;
        this.slice0Y = (float)MathHelpers.randomBetween(2, randomSizeThird) / (float)randomSize;
        this.slice1X = (float)MathHelpers.randomBetween(randomSizeThird * 2 + 1, randomSize - 1) / (float)randomSize;
        this.slice1Y = (float)MathHelpers.randomBetween(randomSizeThird * 2 - 1, randomSize - 1) / (float)randomSize;
        this.inverseSlicePositions = level.field_9229.method_43056();
        this.field_3857 = this.field_3839 = (float)Math.toRadians(MathHelpers.randomBetween(0, 3) * 90);
        this.setInitialVelocity(xSpeed, ySpeed, zSpeed, 0.1f);
        this.field_3844 = MathHelpers.randomBetween(0.75f, 0.9f);
        this.field_3847 = MathHelpers.randomBetween(5, 25);
    }

    protected void setInitialVelocity(double xSpeed, double ySpeed, double zSpeed, float variance) {
        this.field_3852 = xSpeed + (double)(this.field_3851.field_9229.method_43057() * variance - variance / 2.0f);
        this.field_3869 = ySpeed + (double)(this.field_3851.field_9229.method_43057() * variance - variance / 2.0f);
        this.field_3850 = zSpeed + (double)(this.field_3851.field_9229.method_43057() * variance - variance / 2.0f);
    }

    public void method_3070() {
        this.field_3852 *= (double)0.95f;
        this.field_3869 *= (double)0.95f;
        this.field_3850 *= (double)0.95f;
        super.method_3070();
    }

    protected void renderTick(float partialTicks) {
        float percentageAge = (float)this.field_3866 / (float)this.field_3847;
        if ((double)percentageAge > 0.8) {
            float finalA = 1.0f - (class_3532.method_16439((float)partialTicks, (float)this.field_3866, (float)((float)this.field_3866 + 1.0f)) / (float)this.field_3847 - 0.8f) * 5.0f;
            if (finalA < 0.0f) {
                this.field_3841 = 0.0f;
                return;
            }
            this.field_3841 = finalA;
        }
    }

    protected float getParticleScale(float partialTicks) {
        return this.uvScale;
    }

    protected abstract class_2350 getParticleFacingDirection();

    private class_3940.class_8981 getFacingMode(@Nullable class_2350 facingDirection) {
        class_2350 class_23502 = facingDirection;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NORTH", "EAST", "SOUTH", "WEST", "UP", "DOWN"}, (class_2350)class_23502, n)) {
            case 0: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(270.0), 0.0f));
            }
            case 1: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(180.0), 0.0f));
            }
            case 2: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(90.0), 0.0f));
            }
            case 3: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, 0.0f, 0.0f));
            }
            case 4: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(90.0), (float)Math.toRadians(90.0)));
            }
            case 5: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(90.0), (float)Math.toRadians(-90.0)));
            }
        }
        return class_3940.class_8981.field_47457;
    }

    public void method_3074(@NotNull class_4588 vertexConsumer, @NotNull class_4184 camera, float partialTicks) {
        this.renderTick(partialTicks);
        Quaternionf quaternionf = new Quaternionf();
        this.getFacingMode(this.getParticleFacingDirection()).setRotation(quaternionf, camera, partialTicks);
        if (this.field_3839 != 0.0f) {
            quaternionf.rotateZ(class_3532.method_16439((float)partialTicks, (float)this.field_3857, (float)this.field_3839));
        }
        this.renderQuads(vertexConsumer, camera, quaternionf, partialTicks);
    }

    protected void renderQuads(class_4588 buffer, class_4184 camera, Quaternionf quaternion, float partialTicks) {
        class_243 cameraPosition = camera.method_19326();
        float x = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - cameraPosition.method_10216());
        float y = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - cameraPosition.method_10214());
        float z = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - cameraPosition.method_10215());
        int lightColour = this.method_3068(partialTicks);
        this.renderSlice0(buffer, quaternion, x, y, z, lightColour, partialTicks);
        this.renderSlice1(buffer, quaternion, x, y, z, lightColour, partialTicks);
        this.renderSlice2(buffer, quaternion, x, y, z, lightColour, partialTicks);
    }

    protected float getScaledUVCoord(float uv) {
        return uv * this.uvScale + this.uvOffset;
    }

    protected void renderSlice0(class_4588 buffer, Quaternionf quaternion, float x, float y, float z, int lightColour, float partialTicks) {
        float scale = this.getParticleScale(partialTicks);
        float u0 = this.sprite.method_4580(this.getScaledUVCoord(0.0f));
        float u1 = this.sprite.method_4580(this.getScaledUVCoord(this.slice0X));
        float v0 = this.sprite.method_4570(this.getScaledUVCoord(this.inverseSlicePositions ? 1.0f - this.slice0Y : 0.0f));
        float v1 = this.sprite.method_4570(this.getScaledUVCoord(this.inverseSlicePositions ? 1.0f : this.slice0Y));
        this.renderVertex(buffer, quaternion, x, y, z, this.slice0X, this.inverseSlicePositions ? 0.0f : 1.0f - this.slice0Y, u1, v1, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice0X, this.inverseSlicePositions ? this.slice0Y : 1.0f, u1, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, 0.0f, this.inverseSlicePositions ? this.slice0Y : 1.0f, u0, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, 0.0f, this.inverseSlicePositions ? 0.0f : 1.0f - this.slice0Y, u0, v1, lightColour, scale);
    }

    protected void renderSlice1(class_4588 buffer, Quaternionf quaternion, float x, float y, float z, int lightColour, float partialTicks) {
        float scale = this.getParticleScale(partialTicks);
        float u0 = this.sprite.method_4580(this.getScaledUVCoord(this.slice0X));
        float u1 = this.sprite.method_4580(this.getScaledUVCoord(this.slice1X));
        float v0 = this.sprite.method_4570(this.getScaledUVCoord(0.0f));
        float v1 = this.sprite.method_4570(this.getScaledUVCoord(1.0f));
        this.renderVertex(buffer, quaternion, x, y, z, this.slice1X, 0.0f, u1, v1, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice1X, 1.0f, u1, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice0X, 1.0f, u0, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice0X, 0.0f, u0, v1, lightColour, scale);
    }

    protected void renderSlice2(class_4588 buffer, Quaternionf quaternion, float x, float y, float z, int lightColour, float partialTicks) {
        float scale = this.getParticleScale(partialTicks);
        float u0 = this.sprite.method_4580(this.getScaledUVCoord(this.slice1X));
        float u1 = this.sprite.method_4580(this.getScaledUVCoord(1.0f));
        float v0 = this.sprite.method_4570(this.getScaledUVCoord(this.inverseSlicePositions ? 0.0f : this.slice1Y));
        float v1 = this.sprite.method_4570(this.getScaledUVCoord(this.inverseSlicePositions ? 1.0f - this.slice1Y : 1.0f));
        this.renderVertex(buffer, quaternion, x, y, z, 1.0f, this.inverseSlicePositions ? this.slice1Y : 0.0f, u1, v1, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, 1.0f, this.inverseSlicePositions ? 1.0f : 1.0f - this.slice1Y, u1, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice1X, this.inverseSlicePositions ? 1.0f : 1.0f - this.slice1Y, u0, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice1X, this.inverseSlicePositions ? this.slice1Y : 0.0f, u0, v1, lightColour, scale);
    }

    protected void renderVertex(class_4588 buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float u, float v, int packedLight, float scale) {
        RenderingUtil.addVertexToConsumer(buffer, quaternion, x, y, z, xOffset -= 0.5f, yOffset -= 0.5f, scale, u, v, packedLight, this.field_3861, this.field_3842, this.field_3859, this.field_3841);
    }

    @NotNull
    public class_3999 method_18122() {
        return ModParticleRenderTypes.BACKFACE_TERRAIN_PARTICLE;
    }
}

