/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.emitter;

import games.enchanted.blockplaceparticles.config.ConfigHandler;
import games.enchanted.blockplaceparticles.particle.option.ParticleEmitterOptions;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public abstract class AbstractParticleEmitter
extends class_703 {
    protected double emittedXSpeed;
    protected double emittedYSpeed;
    protected double emittedZSpeed;
    protected int emitterInterval;
    protected int emitterIterations;
    protected int particlesPerEmission;
    protected float emitterWidth;
    protected float emitterHeight;
    protected float emitterDepth;
    protected Vector3f emitterVariance;
    protected boolean emitOnFirstTick;

    protected AbstractParticleEmitter(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ParticleEmitterOptions emitterOptions) {
        super(level, x, y, z);
        this.emittedXSpeed = xSpeed;
        this.emittedYSpeed = ySpeed;
        this.emittedZSpeed = zSpeed;
        this.emitterInterval = emitterOptions.getTickInterval();
        this.emitterIterations = emitterOptions.getTickIterations();
        this.particlesPerEmission = emitterOptions.getParticlesPerEmission();
        Vector3f emitterDim = emitterOptions.getDimensions();
        this.emitterWidth = emitterDim.x();
        this.emitterHeight = emitterDim.y();
        this.emitterDepth = emitterDim.z();
        this.emitOnFirstTick = emitterOptions.getEmitOnFirstTick();
        this.emitterVariance = emitterOptions.getVelocityVariance();
        this.method_3077(this.emitterInterval * this.emitterIterations);
        this.field_3874 -= (double)(this.emitterWidth / 2.0f);
        this.field_3854 -= (double)(this.emitterHeight / 2.0f);
        this.field_3871 -= (double)(this.emitterDepth / 2.0f);
    }

    public void method_3070() {
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
            return;
        }
        if (ConfigHandler.debug_showEmitterBounds) {
            this.field_3851.method_8406((class_2394)new class_2390(-65536, 0.5f), this.field_3874, this.field_3854, this.field_3871, 0.0, 0.0, 0.0);
            this.field_3851.method_8406((class_2394)new class_2390(-16711936, 0.5f), this.field_3874 + (double)this.emitterWidth, this.field_3854 + (double)this.emitterHeight, this.field_3871 + (double)this.emitterDepth, 0.0, 0.0, 0.0);
        }
        if ((this.field_3866 - (this.emitOnFirstTick ? 1 : 0)) % this.emitterInterval == 0) {
            for (int i = 0; i < this.particlesPerEmission; ++i) {
                double[] emitPos = this.getRandomPositionInsideBounds();
                this.field_3851.method_8406(this.getParticleToEmit(this.field_3851, emitPos[0], emitPos[1], emitPos[2]), emitPos[0], emitPos[1], emitPos[2], this.emittedXSpeed + (double)(this.field_3851.field_9229.method_43057() * this.emitterVariance.x - this.emitterVariance.x / 2.0f), this.emittedYSpeed + (double)(this.field_3851.field_9229.method_43057() * this.emitterVariance.y - this.emitterVariance.y / 2.0f), this.emittedZSpeed + (double)(this.field_3851.field_9229.method_43057() * this.emitterVariance.z - this.emitterVariance.z / 2.0f));
            }
        }
    }

    protected double[] getRandomPositionInsideBounds() {
        double newX = this.field_3874 + (double)(this.emitterWidth * this.field_3851.field_9229.method_43057());
        double newY = this.field_3854 + (double)(this.emitterHeight * this.field_3851.field_9229.method_43057());
        double newZ = this.field_3871 + (double)(this.emitterDepth * this.field_3851.field_9229.method_43057());
        return new double[]{newX, newY, newZ};
    }

    protected abstract class_2394 getParticleToEmit(class_638 var1, double var2, double var4, double var6);

    public void method_3074(@NotNull class_4588 vertexConsumer, @NotNull class_4184 camera, float v) {
    }

    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17832;
    }
}

