/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.manager.server;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.lopymine.patpat.PatPat;
import net.lopymine.patpat.config.resourcepack.ListMode;
import net.lopymine.patpat.config.server.PatPatServerConfig;
import net.lopymine.patpat.extension.TextExtension;
import net.lopymine.patpat.utils.CommandTextBuilder;
import net.lopymine.patpat.utils.ServerNetworkUtils;
import net.lopymine.patpat.utils.TextUtils;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class PatPatServerCommandManager {
    private static final class_5250 PATPAT_ID = TextUtils.literal("[\u00a7aPatPat\u00a7f] ");

    private PatPatServerCommandManager() {
        throw new IllegalStateException("Manager class");
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"patpat").requires(context -> context.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(List.of("WHITELIST", "BLACKLIST", "DISABLED"), (SuggestionsBuilder)builder)).executes(PatPatServerCommandManager::onSetListMode)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"profile", (ArgumentType)class_2191.method_9329()).suggests((context, builder) -> class_2172.method_9265((Iterable)((class_2168)context.getSource()).method_9262(), (SuggestionsBuilder)builder)).executes(context -> PatPatServerCommandManager.onListChange((CommandContext<class_2168>)context, true))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"profile", (ArgumentType)class_2191.method_9329()).suggests((context, builder) -> class_2172.method_9265(ServerNetworkUtils.getPlayersFromList(((class_2168)context.getSource()).method_9211().method_3760(), PatPat.getConfig()), (SuggestionsBuilder)builder)).executes(context -> PatPatServerCommandManager.onListChange((CommandContext<class_2168>)context, false)))))));
    }

    private static int onListChange(CommandContext<class_2168> context, boolean add) throws CommandSyntaxException {
        PatPatServerConfig config = PatPat.getConfig();
        Map<UUID, String> players = config.getList();
        Collection profile = class_2191.method_9330(context, (String)"profile");
        for (GameProfile gameProfile : profile) {
            String name = gameProfile.getName();
            UUID uuid = gameProfile.getId();
            boolean success = add ? !players.containsKey(uuid) && players.put(uuid, name) == null : players.containsKey(uuid) && players.remove(uuid) != null;
            String action = add ? "add" : "remove";
            String result = success ? "success" : "failed";
            String key = String.format("list.%s.%s", action, result);
            class_2561 text = CommandTextBuilder.startBuilder(key, name).withShowEntity(class_1299.field_6097, uuid, name).withClickEvent(class_2558.class_2559.field_21462, uuid).build();
            ((class_2168)context.getSource()).method_9226(() -> PATPAT_ID.method_27661().method_10852(text), true);
            if (success) {
                PatPat.LOGGER.info(TextExtension.asString(text), new Object[0]);
                continue;
            }
            PatPat.LOGGER.warn(TextExtension.asString(text), new Object[0]);
        }
        config.save();
        return 1;
    }

    private static int onSetListMode(CommandContext<class_2168> context) {
        boolean success;
        String modeId = StringArgumentType.getString(context, (String)"mode");
        PatPatServerConfig config = PatPat.getConfig();
        ListMode listMode = ListMode.getById(modeId);
        boolean bl = success = listMode != null;
        if (success) {
            config.setListMode(listMode);
        }
        String result = success ? "success" : "failed";
        String key = String.format("list.mode.%s", result);
        String arg = success ? listMode.getText() : modeId;
        CommandTextBuilder builder = CommandTextBuilder.startBuilder(key, arg);
        if (!success) {
            builder.withHoverText(Arrays.stream(ListMode.values()).map(ListMode::getText).toArray());
        }
        class_2561 text = builder.build();
        ((class_2168)context.getSource()).method_9226(() -> PATPAT_ID.method_27661().method_10852(text), true);
        if (success) {
            PatPat.LOGGER.info(TextExtension.asString(text), new Object[0]);
        } else {
            PatPat.LOGGER.warn(TextExtension.asString(text), new Object[0]);
        }
        return success ? 1 : 0;
    }
}

