/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.manager.client;

import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.config.client.PatPatClientConfig;
import net.lopymine.patpat.config.resourcepack.ListMode;
import net.lopymine.patpat.config.resourcepack.PlayerConfig;
import net.lopymine.patpat.entity.PatEntity;
import net.lopymine.patpat.manager.client.PatPatClientManager;
import net.lopymine.patpat.manager.client.PatPatClientSoundManager;
import net.lopymine.patpat.packet.PatEntityForReplayModS2CPacket;
import net.lopymine.patpat.packet.PatEntityS2CPacket;
import net.lopymine.patpat.utils.WorldUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_5520;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class PatPatClientPacketManager {
    private PatPatClientPacketManager() {
        throw new IllegalStateException("Manager class");
    }

    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver(PatEntityForReplayModS2CPacket.TYPE, (packet, context) -> PatPatClientPacketManager.handlePatting(packet.getWhoPattedUuid(), packet.getPattedEntityUuid(), true));
        ClientPlayNetworking.registerGlobalReceiver(PatEntityS2CPacket.TYPE, (packet, context) -> PatPatClientPacketManager.handlePatting(packet.getWhoPattedUuid(), packet.getPattedEntityUuid(), false));
    }

    private static void handlePatting(UUID whoPattedUuid, UUID pattedEntityUuid, boolean replayModPacket) {
        PatPatClient.LOGGER.debug("Received packet from server, {} patted {}, replayModPacket: {}", whoPattedUuid, pattedEntityUuid, replayModPacket);
        class_638 clientWorld = class_310.method_1551().field_1687;
        class_746 player = class_310.method_1551().field_1724;
        PatPatClientConfig config = PatPatClient.getConfig();
        if (!config.isModEnabled()) {
            return;
        }
        if (clientWorld == null) {
            return;
        }
        boolean pattedMe = pattedEntityUuid.equals(class_310.method_1551().method_1548().method_44717());
        if (pattedMe && !config.isPatMeEnabled()) {
            return;
        }
        if (PatPatClientPacketManager.isBlocked(config, whoPattedUuid)) {
            return;
        }
        class_1297 pattedEntity = WorldUtils.getEntity(clientWorld, pattedEntityUuid);
        if (!(pattedEntity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)pattedEntity;
        class_1297 playerEntity = WorldUtils.getEntity(clientWorld, whoPattedUuid);
        if (!(playerEntity instanceof class_1657)) {
            return;
        }
        PatEntity patEntity = PatPatClientManager.pat(livingEntity, PlayerConfig.of(playerEntity.method_5477().getString(), whoPattedUuid));
        if (config.isSoundsEnabled() && !replayModPacket) {
            PatPatClientSoundManager.playSound(patEntity, (class_1657)player, config.getSoundsVolume());
        }
    }

    private static boolean isBlocked(PatPatClientConfig config, UUID playerUuid) {
        class_5520 socialManager = class_310.method_1551().method_31320();
        return config.getListMode() == ListMode.WHITELIST && !config.getPlayers().containsKey(playerUuid) || config.getListMode() == ListMode.BLACKLIST && config.getPlayers().containsKey(playerUuid) || socialManager.method_31392(playerUuid) || socialManager.method_31340(playerUuid) || socialManager.method_31391(playerUuid);
    }
}

