/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.manager.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.lopymine.patpat.argument.ListModeArgumentType;
import net.lopymine.patpat.argument.PlayerInfoArgumentType;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.config.client.PatPatClientConfig;
import net.lopymine.patpat.config.resourcepack.ListMode;
import net.lopymine.patpat.utils.ClientNetworkUtils;
import net.lopymine.patpat.utils.CommandTextBuilder;
import net.lopymine.patpat.utils.TextUtils;
import net.minecraft.class_1299;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class PatPatClientCommandManager {
    private static final class_5250 PATPAT_ID = TextUtils.literal("[\u00a7aPatPat/Client\u00a7f] ");
    private static final String PLAYER_ARGUMENT_NAME = "player";

    private PatPatClientCommandManager() {
        throw new IllegalStateException("Manager class");
    }

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"patpat-client").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"mode", (ArgumentType)ListModeArgumentType.listMode()).executes(PatPatClientCommandManager::onSetListMode)))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)PLAYER_ARGUMENT_NAME, (ArgumentType)PlayerInfoArgumentType.player()).suggests((context, builder) -> class_2172.method_9265((Iterable)((FabricClientCommandSource)context.getSource()).method_9262(), (SuggestionsBuilder)builder)).executes(context -> PatPatClientCommandManager.onListChange((CommandContext<FabricClientCommandSource>)context, true))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)PLAYER_ARGUMENT_NAME, (ArgumentType)PlayerInfoArgumentType.player()).suggests((context, builder) -> class_2172.method_9265(ClientNetworkUtils.getOnlinePlayersFromUuids(((FabricClientCommandSource)context.getSource()).getClient().method_1562(), PatPatClient.getConfig()), (SuggestionsBuilder)builder)).executes(context -> PatPatClientCommandManager.onListChange((CommandContext<FabricClientCommandSource>)context, false)))))).then(ClientCommandManager.literal((String)"off").executes(context -> PatPatClientCommandManager.switchPatPatState((CommandContext<FabricClientCommandSource>)context, false)))).then(ClientCommandManager.literal((String)"on").executes(context -> PatPatClientCommandManager.switchPatPatState((CommandContext<FabricClientCommandSource>)context, true)))));
    }

    private static int onListChange(CommandContext<FabricClientCommandSource> context, boolean add) {
        PatPatClientConfig config = PatPatClient.getConfig();
        HashMap<UUID, String> players = config.getPlayers();
        PlayerInfoArgumentType.PlayerInfo playerInfo = PlayerInfoArgumentType.getPlayerInfo(PLAYER_ARGUMENT_NAME, context);
        UUID uuid = playerInfo.getUuid();
        String name = playerInfo.getNickname();
        boolean success = add ? !players.containsKey(uuid) && players.put(uuid, name) == null : players.containsKey(uuid) && players.remove(uuid) != null;
        String action = add ? "add" : "remove";
        String result = success ? "success" : "failed";
        String key = String.format("list.%s.%s", action, result);
        class_2561 text = CommandTextBuilder.startBuilder(key, name).withShowEntity(class_1299.field_6097, uuid, name).withClickEvent(class_2558.class_2559.field_21462, uuid).build();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)PATPAT_ID.method_27661().method_10852(text));
        config.save();
        return 1;
    }

    private static int onSetListMode(CommandContext<FabricClientCommandSource> context) {
        PatPatClientConfig config = PatPatClient.getConfig();
        ListMode mode = ListModeArgumentType.getListMode(context, "mode");
        config.setListMode(mode);
        config.save();
        class_2561 text = CommandTextBuilder.startBuilder("list.mode.success", mode.getText()).build();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)PATPAT_ID.method_27661().method_10852(text));
        return 1;
    }

    private static int switchPatPatState(CommandContext<FabricClientCommandSource> context, boolean state) {
        class_2561 text;
        PatPatClientConfig config = PatPatClient.getConfig();
        if (config.isModEnabled() != state) {
            config.setModEnabled(state);
            config.save();
            text = CommandTextBuilder.startBuilder(state ? "on.success" : "off.success", new Object[0]).build();
        } else {
            text = CommandTextBuilder.startBuilder(state ? "on.already" : "off.already", new Object[0]).build();
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)PATPAT_ID.method_27661().method_10852(text));
        return 1;
    }
}

