/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.config.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.config.resourcepack.ListMode;
import net.lopymine.patpat.manager.PatPatConfigManager;
import net.lopymine.patpat.utils.VersionedThings;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class PatPatClientConfig {
    public static final Codec<PatPatClientConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(VersionedThings.UUID_CODEC, (Codec)Codec.STRING).xmap(HashMap::new, HashMap::new).fieldOf("list").forGetter(PatPatClientConfig::getPlayers), (App)Codec.BOOL.fieldOf("bypassServerResourcePackPriorityEnabled").forGetter(PatPatClientConfig::isBypassServerResourcePackEnabled), (App)Codec.BOOL.fieldOf("hidingNicknameEnabled").forGetter(PatPatClientConfig::isNicknameHidingEnabled), (App)Codec.BOOL.fieldOf("swingHandEnabled").forGetter(PatPatClientConfig::isSwingHandEnabled), (App)Codec.BOOL.fieldOf("soundsEnabled").forGetter(PatPatClientConfig::isSoundsEnabled), (App)Codec.BOOL.fieldOf("patMeEnabled").forGetter(PatPatClientConfig::isPatMeEnabled), (App)Codec.BOOL.fieldOf("cameraShackingEnabled").forGetter(PatPatClientConfig::isCameraShackingEnabled), (App)Codec.BOOL.fieldOf("modEnabled").forGetter(PatPatClientConfig::isModEnabled), (App)Codec.FLOAT.fieldOf("soundsVolume").forGetter(PatPatClientConfig::getSoundsVolume), (App)ListMode.CODEC.fieldOf("listMode").forGetter(PatPatClientConfig::getListMode), (App)Codec.FLOAT.fieldOf("offsetX").forGetter(PatPatClientConfig::getAnimationOffsetX), (App)Codec.FLOAT.fieldOf("offsetY").forGetter(PatPatClientConfig::getAnimationOffsetY), (App)Codec.FLOAT.fieldOf("offsetZ").forGetter(PatPatClientConfig::getAnimationOffsetZ), (App)Codec.BOOL.fieldOf("debugLogEnabled").forGetter(PatPatClientConfig::isDebugLogEnabled), (App)Codec.BOOL.fieldOf("skipOldAnimationsEnabled").forGetter(PatPatClientConfig::isSkipOldAnimationsEnabled), (App)Codec.FLOAT.optionalFieldOf("patWeight").xmap(o -> o.orElse(Float.valueOf(0.425f)), Optional::ofNullable).forGetter(PatPatClientConfig::getPatWeight)).apply((Applicative)instance, PatPatClientConfig::new));
    public static final PatPatClientConfig DEFAULT = new PatPatClientConfig();
    private static final File CONFIG_FILE = PatPatConfigManager.CONFIG_PATH.resolve("patpat-client.json5").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final HashMap<UUID, String> players;
    private boolean bypassServerResourcePackEnabled;
    private boolean nicknameHidingEnabled;
    private boolean swingHandEnabled;
    private boolean soundsEnabled;
    private boolean patMeEnabled;
    private boolean cameraShackingEnabled;
    private boolean modEnabled;
    private float soundsVolume;
    private ListMode listMode;
    private float animationOffsetX;
    private float animationOffsetY;
    private float animationOffsetZ;
    private boolean debugLogEnabled;
    private boolean skipOldAnimationsEnabled;
    private float patWeight;

    public PatPatClientConfig() {
        this.bypassServerResourcePackEnabled = false;
        this.nicknameHidingEnabled = true;
        this.swingHandEnabled = true;
        this.soundsEnabled = true;
        this.patMeEnabled = true;
        this.cameraShackingEnabled = true;
        this.modEnabled = true;
        this.soundsVolume = 1.0f;
        this.listMode = ListMode.DISABLED;
        this.players = new HashMap();
        this.animationOffsetX = 0.0f;
        this.animationOffsetY = 0.0f;
        this.animationOffsetZ = 0.0f;
        this.debugLogEnabled = false;
        this.skipOldAnimationsEnabled = true;
        this.patWeight = 0.425f;
    }

    public static PatPatClientConfig getInstance() {
        return PatPatClientConfig.read();
    }

    @NotNull
    private static PatPatClientConfig create() {
        PatPatClientConfig config = new PatPatClientConfig();
        try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
            String json = GSON.toJson((JsonElement)CODEC.encode((Object)config, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow());
            writer.write(json);
        }
        catch (Exception e) {
            PatPatClient.LOGGER.error("Failed to create config", e);
        }
        return config;
    }

    private static PatPatClientConfig read() {
        PatPatClientConfig patPatClientConfig;
        if (!CONFIG_FILE.exists()) {
            return PatPatClientConfig.create();
        }
        FileReader reader = new FileReader(CONFIG_FILE, StandardCharsets.UTF_8);
        try {
            patPatClientConfig = (PatPatClientConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow()).getFirst();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                PatPatClient.LOGGER.error("Failed to read config", e);
                return PatPatClientConfig.create();
            }
        }
        reader.close();
        return patPatClientConfig;
    }

    public void save() {
        PatPatClient.setConfig(this);
        CompletableFuture.runAsync(() -> {
            PatPatClient.LOGGER.debug("Saving PatPat Client Config...", new Object[0]);
            try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
                String json = GSON.toJson((JsonElement)CODEC.encode((Object)this, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow());
                writer.write(json);
            }
            catch (Exception e) {
                PatPatClient.LOGGER.error("Failed to save config", e);
            }
            PatPatClient.LOGGER.debug("Saved PatPat Client Config", new Object[0]);
        });
    }

    public void setBypassServerResourcePackEnabled(boolean value) {
        this.bypassServerResourcePackEnabled = value;
        class_310 client = class_310.method_1551();
        boolean bl = client.method_1520().method_29210().stream().anyMatch(s -> s.startsWith("server/"));
        if (bl) {
            client.method_1521();
        }
    }

    public HashMap<UUID, String> getPlayers() {
        return this.players;
    }

    public boolean isBypassServerResourcePackEnabled() {
        return this.bypassServerResourcePackEnabled;
    }

    public boolean isNicknameHidingEnabled() {
        return this.nicknameHidingEnabled;
    }

    public boolean isSwingHandEnabled() {
        return this.swingHandEnabled;
    }

    public boolean isSoundsEnabled() {
        return this.soundsEnabled;
    }

    public boolean isPatMeEnabled() {
        return this.patMeEnabled;
    }

    public boolean isCameraShackingEnabled() {
        return this.cameraShackingEnabled;
    }

    public boolean isModEnabled() {
        return this.modEnabled;
    }

    public float getSoundsVolume() {
        return this.soundsVolume;
    }

    public ListMode getListMode() {
        return this.listMode;
    }

    public float getAnimationOffsetX() {
        return this.animationOffsetX;
    }

    public float getAnimationOffsetY() {
        return this.animationOffsetY;
    }

    public float getAnimationOffsetZ() {
        return this.animationOffsetZ;
    }

    public boolean isDebugLogEnabled() {
        return this.debugLogEnabled;
    }

    public boolean isSkipOldAnimationsEnabled() {
        return this.skipOldAnimationsEnabled;
    }

    public float getPatWeight() {
        return this.patWeight;
    }

    public void setNicknameHidingEnabled(boolean nicknameHidingEnabled) {
        this.nicknameHidingEnabled = nicknameHidingEnabled;
    }

    public void setSwingHandEnabled(boolean swingHandEnabled) {
        this.swingHandEnabled = swingHandEnabled;
    }

    public void setSoundsEnabled(boolean soundsEnabled) {
        this.soundsEnabled = soundsEnabled;
    }

    public void setPatMeEnabled(boolean patMeEnabled) {
        this.patMeEnabled = patMeEnabled;
    }

    public void setCameraShackingEnabled(boolean cameraShackingEnabled) {
        this.cameraShackingEnabled = cameraShackingEnabled;
    }

    public void setModEnabled(boolean modEnabled) {
        this.modEnabled = modEnabled;
    }

    public void setSoundsVolume(float soundsVolume) {
        this.soundsVolume = soundsVolume;
    }

    public void setListMode(ListMode listMode) {
        this.listMode = listMode;
    }

    public void setAnimationOffsetX(float animationOffsetX) {
        this.animationOffsetX = animationOffsetX;
    }

    public void setAnimationOffsetY(float animationOffsetY) {
        this.animationOffsetY = animationOffsetY;
    }

    public void setAnimationOffsetZ(float animationOffsetZ) {
        this.animationOffsetZ = animationOffsetZ;
    }

    public void setDebugLogEnabled(boolean debugLogEnabled) {
        this.debugLogEnabled = debugLogEnabled;
    }

    public void setSkipOldAnimationsEnabled(boolean skipOldAnimationsEnabled) {
        this.skipOldAnimationsEnabled = skipOldAnimationsEnabled;
    }

    public void setPatWeight(float patWeight) {
        this.patWeight = patWeight;
    }

    public PatPatClientConfig(HashMap<UUID, String> players, boolean bypassServerResourcePackEnabled, boolean nicknameHidingEnabled, boolean swingHandEnabled, boolean soundsEnabled, boolean patMeEnabled, boolean cameraShackingEnabled, boolean modEnabled, float soundsVolume, ListMode listMode, float animationOffsetX, float animationOffsetY, float animationOffsetZ, boolean debugLogEnabled, boolean skipOldAnimationsEnabled, float patWeight) {
        this.players = players;
        this.bypassServerResourcePackEnabled = bypassServerResourcePackEnabled;
        this.nicknameHidingEnabled = nicknameHidingEnabled;
        this.swingHandEnabled = swingHandEnabled;
        this.soundsEnabled = soundsEnabled;
        this.patMeEnabled = patMeEnabled;
        this.cameraShackingEnabled = cameraShackingEnabled;
        this.modEnabled = modEnabled;
        this.soundsVolume = soundsVolume;
        this.listMode = listMode;
        this.animationOffsetX = animationOffsetX;
        this.animationOffsetY = animationOffsetY;
        this.animationOffsetZ = animationOffsetZ;
        this.debugLogEnabled = debugLogEnabled;
        this.skipOldAnimationsEnabled = skipOldAnimationsEnabled;
        this.patWeight = patWeight;
    }
}

