/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.argument;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.utils.CommandTextBuilder;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;

public class PlayerInfoArgumentType
implements ArgumentType<PlayerInfo> {
    public static final DynamicCommandExceptionType FAILED_PARSING = new DynamicCommandExceptionType(o -> CommandTextBuilder.startBuilder("argument.player_info.exception.failed_parsing", o).build());
    public static final DynamicCommandExceptionType UNKNOWN_PLAYER = new DynamicCommandExceptionType(o -> CommandTextBuilder.startBuilder("argument.player_info.exception.unknown_player", o).build());
    private static final Collection<String> EXAMPLES = Arrays.asList("LopyMine", "nikita51", "192e3748-12d5-4573-a8a5-479cd394a1dc", "7b829ed5-9b74-428f-9b4d-ede06975fbc1");

    private PlayerInfoArgumentType() {
    }

    @NotNull
    public static PlayerInfoArgumentType player() {
        return new PlayerInfoArgumentType();
    }

    public static <S> PlayerInfo getPlayerInfo(String name, @NotNull CommandContext<S> context) {
        return (PlayerInfo)context.getArgument(name, PlayerInfo.class);
    }

    public PlayerInfo parse(@NotNull StringReader reader) throws CommandSyntaxException {
        try {
            String s = reader.readUnquotedString();
            PatPatClient.LOGGER.debug("Parsed PlayerInfo from PlayerInfoArgumentType: {}", s);
            class_634 networkHandler = class_310.method_1551().method_1562();
            if (networkHandler == null) {
                throw FAILED_PARSING.createWithContext((ImmutableStringReader)reader, (Object)reader.getString());
            }
            for (class_640 entry : networkHandler.method_2880()) {
                GameProfile profile = entry.method_2966();
                if (profile.getName().equals(s)) {
                    return new PlayerInfo(s, profile.getId());
                }
                UUID uuid = UUID.fromString(s);
                if (!profile.getId().equals(uuid)) continue;
                return new PlayerInfo(profile.getName(), uuid);
            }
            throw UNKNOWN_PLAYER.createWithContext((ImmutableStringReader)reader, (Object)reader.getString());
        }
        catch (CommandSyntaxException e) {
            throw FAILED_PARSING.createWithContext((ImmutableStringReader)reader, (Object)reader.getString());
        }
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class PlayerInfo {
        private final class_3545<String, UUID> pair;

        public PlayerInfo(String nickname, UUID uuid) {
            this.pair = new class_3545((Object)nickname, (Object)uuid);
        }

        public String getNickname() {
            return (String)this.pair.method_15442();
        }

        public UUID getUuid() {
            return (UUID)this.pair.method_15441();
        }
    }
}

