/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat;

import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.config.client.PatPatClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatLogger {
    private final Logger logger;
    private final String name;

    public PatLogger(String name) {
        this.name = name;
        this.logger = LoggerFactory.getLogger((String)this.name);
    }

    public void debug(String text, Object ... args) {
        PatPatClientConfig config = PatPatClient.getConfig();
        if (config != null && config.isDebugLogEnabled()) {
            text = "[%s/DEBUG]: %s".formatted(this.name, text);
            this.logger.info(text, args);
        }
    }

    public void info(String text, Object ... args) {
        text = this.prepare(text);
        this.logger.info(text, args);
    }

    public void warn(String text, Object ... args) {
        text = this.prepare(text);
        this.logger.warn(text, args);
    }

    public void error(String text, Object ... args) {
        text = this.prepare(text);
        this.logger.error(text, args);
    }

    private String prepare(String text) {
        return "[%s]: %s".formatted(this.name, text);
    }

    public Logger getLogger() {
        return this.logger;
    }
}

