/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_modification;

import com.github.luben.zstd.Zstd;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.DummyBuffer;
import com.moulberry.axiom.world_modification.HistoryBuffer;
import com.moulberry.axiom.world_modification.HistoryEntry;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_403;

public class HistoryIO {
    private static final Lock lock = new ReentrantLock();
    private static final class_2540 friendlyDirect = new class_2540(Unpooled.directBuffer());
    private static final String ENTRY_PREFIX = "entry";
    private static final String CHUNK_PREFIX = "chunk";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HistoryBuffer<BlockOrBiomeBuffer> loadHistory(Path historyFolder) {
        lock.lock();
        try {
            if (!Files.exists(historyFolder, new LinkOption[0])) {
                HistoryBuffer<BlockOrBiomeBuffer> historyBuffer = new HistoryBuffer<BlockOrBiomeBuffer>();
                return historyBuffer;
            }
            Files.createDirectories(historyFolder, new FileAttribute[0]);
            HistoryIO.completePendingTransaction(historyFolder);
            boolean positionMissing = true;
            int position = -1;
            int size = 0;
            ByteBuffer readBuffer = ByteBuffer.allocateDirect(2048);
            Path positionPath = historyFolder.resolve("position");
            if (Files.exists(positionPath, new LinkOption[0])) {
                try (SeekableByteChannel in2 = Files.newByteChannel(positionPath, StandardOpenOption.READ);){
                    in2.read(readBuffer);
                    readBuffer.flip();
                    class_2540 byteBuf = new class_2540(Unpooled.wrappedBuffer((ByteBuffer)readBuffer));
                    position = byteBuf.readInt();
                    size = byteBuf.readInt();
                    positionMissing = false;
                }
                catch (Exception in2) {
                    // empty catch block
                }
            }
            Int2ObjectOpenHashMap historyEntries = new Int2ObjectOpenHashMap();
            Pattern pattern = Pattern.compile("(entry|chunk)(\\d+).hist");
            Buffer decompressionBuffer = null;
            try (Object ds = Files.newDirectoryStream(historyFolder);){
                Iterator<Path> iterator = ds.iterator();
                while (iterator.hasNext()) {
                    Path subpath = iterator.next();
                    String filename = subpath.getFileName().toString();
                    Matcher matcher = pattern.matcher(filename);
                    if (!matcher.matches()) continue;
                    int fileIndex = Integer.parseInt(matcher.group(2));
                    if (fileIndex < 0) {
                        throw new FaultyImplementationError();
                    }
                    String type2 = matcher.group(1);
                    if (type2.equals(ENTRY_PREFIX)) {
                        if (fileIndex + 1 > size) {
                            size = fileIndex + 1;
                        }
                        try (SeekableByteChannel in = Files.newByteChannel(subpath, StandardOpenOption.READ);){
                            int fileSize = (int)in.size();
                            if (readBuffer.capacity() < fileSize) {
                                readBuffer = ByteBuffer.allocateDirect(fileSize);
                            } else {
                                readBuffer.clear();
                            }
                            in.read(readBuffer);
                            readBuffer.flip();
                            class_2540 byteBuf = new class_2540(Unpooled.wrappedBuffer((ByteBuffer)readBuffer));
                            historyEntries.put(fileIndex, HistoryEntry.load(byteBuf));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (type2.equals(CHUNK_PREFIX)) {
                        int maxPosition = fileIndex * 16 + 15;
                        if (maxPosition + 1 > size) {
                            size = maxPosition + 1;
                        }
                        try (SeekableByteChannel in = Files.newByteChannel(subpath, StandardOpenOption.READ);){
                            int fileSize = (int)in.size();
                            if (readBuffer.capacity() < fileSize) {
                                readBuffer = ByteBuffer.allocateDirect(fileSize);
                            } else {
                                readBuffer.clear();
                            }
                            in.read(readBuffer);
                            readBuffer.flip();
                            int decompressedSize = (int)Zstd.decompressedSize(readBuffer);
                            if (decompressionBuffer == null || decompressionBuffer.capacity() < decompressedSize) {
                                decompressionBuffer = ByteBuffer.allocateDirect(decompressedSize);
                            } else {
                                ((ByteBuffer)decompressionBuffer).clear();
                            }
                            Zstd.decompress((ByteBuffer)decompressionBuffer, readBuffer);
                            ((ByteBuffer)decompressionBuffer).flip();
                            class_2540 byteBuf = new class_2540(Unpooled.wrappedBuffer((ByteBuffer)decompressionBuffer));
                            for (int i = 0; i <= 15; ++i) {
                                HistoryEntry<BlockOrBiomeBuffer> historyEntry = HistoryEntry.load(byteBuf);
                                historyEntries.put(fileIndex * 16 + i, historyEntry);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    throw new FaultyImplementationError();
                }
            }
            if (historyEntries.isEmpty()) {
                ds = new HistoryBuffer();
                return ds;
            }
            IntArrayList missingElements = new IntArrayList();
            DummyBuffer dummy = new DummyBuffer();
            HistoryBuffer<BlockOrBiomeBuffer> historyBuffer = new HistoryBuffer<BlockOrBiomeBuffer>();
            for (int i = 0; i < size; ++i) {
                HistoryEntry entry = (HistoryEntry)historyEntries.get(i);
                if (entry == null) {
                    missingElements.add(i);
                    historyBuffer.push(new HistoryEntry<DummyBuffer>(dummy, dummy, class_2338.field_10980, "~Corrupted~", 0));
                    continue;
                }
                historyBuffer.push(entry);
            }
            if (positionMissing) {
                HistoryIO.displayWarning("Axiom History", "Error: position file has been corrupted or deleted", "Axiom will try to recover, however some data may be lost");
            } else {
                historyBuffer.unsafeSetPosition(position);
            }
            if (!missingElements.isEmpty()) {
                HistoryIO.displayWarning("Axiom History", "Error: " + missingElements.size() + " history entry file(s) have been corrupted or deleted", "It is very likely data has been lost", "Missing history elements: " + Arrays.toString(missingElements.toIntArray()));
            }
            HistoryBuffer<BlockOrBiomeBuffer> historyBuffer2 = historyBuffer;
            return historyBuffer2;
        }
        catch (Exception e) {
            HistoryIO.displayException(e);
        }
        finally {
            lock.unlock();
        }
        return new HistoryBuffer<BlockOrBiomeBuffer>();
    }

    private static void completePendingTransaction(Path historyFolder) throws IOException {
        Path path = historyFolder.resolve("transaction");
        if (Files.exists(path, new LinkOption[0])) {
            byte[] bytes = Files.readAllBytes(path);
            class_2540 friendlyByteBuf = new class_2540(Unpooled.wrappedBuffer((byte[])bytes));
            try {
                byte transactionType = friendlyByteBuf.readByte();
                switch (transactionType) {
                    case 0: {
                        int position = friendlyByteBuf.readInt();
                        int oldSize = friendlyByteBuf.readInt();
                        HistoryIO.doPushEntry(historyFolder, position, oldSize);
                        break;
                    }
                    case 1: {
                        int position = friendlyByteBuf.readInt();
                        int size = friendlyByteBuf.readInt();
                        HistoryIO.doSetPosition(historyFolder, position, size);
                        break;
                    }
                    case 2: {
                        HistoryIO.doClear(historyFolder);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Files.delete(path);
        }
        Files.deleteIfExists(historyFolder.resolve("buffer.hist"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushEntry(Path historyFolder, HistoryEntry<?> historyEntry, int position, int oldSize) {
        lock.lock();
        try {
            if (!Files.isDirectory(historyFolder, new LinkOption[0])) {
                Files.deleteIfExists(historyFolder);
            }
            Files.createDirectories(historyFolder, new FileAttribute[0]);
            HistoryIO.completePendingTransaction(historyFolder);
            friendlyDirect.method_52935();
            historyEntry.save(friendlyDirect);
            ByteBuffer buffer = friendlyDirect.nioBuffer();
            Path bufferPath = historyFolder.resolve("buffer.hist");
            try (SeekableByteChannel out = Files.newByteChannel(bufferPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC);){
                out.write(buffer);
            }
            int transactionIndex = friendlyDirect.writerIndex();
            friendlyDirect.method_52997(0);
            friendlyDirect.method_53002(position);
            friendlyDirect.method_53002(oldSize);
            HistoryIO.beginTransaction(historyFolder, friendlyDirect.nioBuffer(transactionIndex, friendlyDirect.writerIndex() - transactionIndex));
            HistoryIO.doPushEntry(historyFolder, position, oldSize);
            HistoryIO.endTransaction(historyFolder);
        }
        catch (IOException e) {
            HistoryIO.displayException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private static void doPushEntry(Path historyFolder, int position, int oldSize) throws IOException {
        Path bufferPath;
        int chunk = position / 16;
        int minPosition = chunk * 16;
        int maxPosition = minPosition + 16;
        int positionWithinChunk = position - minPosition;
        ByteBuffer readBuffer = null;
        Path chunkFile = historyFolder.resolve(CHUNK_PREFIX + chunk + ".hist");
        if (Files.exists(chunkFile, new LinkOption[0])) {
            try (SeekableByteChannel in = Files.newByteChannel(chunkFile, StandardOpenOption.READ);){
                int fileSize = (int)in.size();
                readBuffer = ByteBuffer.allocateDirect(fileSize);
                in.read(readBuffer);
                readBuffer.flip();
            }
            int decompressedSize = (int)Zstd.decompressedSize(readBuffer);
            ByteBuffer decompressionBuffer = ByteBuffer.allocateDirect(decompressedSize);
            Zstd.decompress(decompressionBuffer, readBuffer);
            decompressionBuffer.flip();
            class_2540 byteBuf = new class_2540(Unpooled.wrappedBuffer((ByteBuffer)decompressionBuffer));
            for (int i = 0; i <= positionWithinChunk; ++i) {
                try {
                    HistoryEntry<BlockOrBiomeBuffer> historyEntry = HistoryEntry.load(byteBuf);
                    friendlyDirect.method_52935();
                    historyEntry.save(friendlyDirect);
                    ByteBuffer buffer = friendlyDirect.nioBuffer();
                    Path path = historyFolder.resolve(ENTRY_PREFIX + (minPosition + i) + ".hist");
                    try (SeekableByteChannel out = Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC);){
                        out.write(buffer);
                        continue;
                    }
                }
                catch (Exception e) {
                    Axiom.LOGGER.error("Failed to load history", e);
                    break;
                }
            }
            Files.deleteIfExists(chunkFile);
        }
        if (Files.exists(bufferPath = historyFolder.resolve("buffer.hist"), new LinkOption[0])) {
            Path entryPath = historyFolder.resolve(ENTRY_PREFIX + position + ".hist");
            Files.move(bufferPath, entryPath, StandardCopyOption.REPLACE_EXISTING);
        }
        Path positionPath = historyFolder.resolve("position");
        try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(positionPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC));){
            out.writeInt(position);
            out.writeInt(position + 1);
        }
        for (int e = position + 1; e < oldSize; ++e) {
            Files.deleteIfExists(historyFolder.resolve(ENTRY_PREFIX + e + ".hist"));
        }
        for (int c = position / 16 + 1; c < (oldSize + 15) / 16; ++c) {
            Files.deleteIfExists(historyFolder.resolve(CHUNK_PREFIX + c + ".hist"));
        }
        if (positionWithinChunk == 15) {
            ByteBuffer writeBuffer = ByteBuffer.allocateDirect(2048);
            for (int e = minPosition; e < maxPosition; ++e) {
                Path histEntry = historyFolder.resolve(ENTRY_PREFIX + e + ".hist");
                if (!Files.exists(histEntry, new LinkOption[0])) {
                    return;
                }
                try (SeekableByteChannel in = Files.newByteChannel(histEntry, StandardOpenOption.READ);){
                    int fileSize = (int)in.size();
                    if (readBuffer == null || readBuffer.capacity() < fileSize) {
                        readBuffer = ByteBuffer.allocateDirect(fileSize);
                    } else {
                        readBuffer.clear();
                    }
                    in.read(readBuffer);
                    readBuffer.flip();
                    class_2540 byteBuf = new class_2540(Unpooled.wrappedBuffer((ByteBuffer)readBuffer));
                    HistoryEntry.load(byteBuf);
                    int need = writeBuffer.position() + readBuffer.limit();
                    if (writeBuffer.capacity() <= need) {
                        int newCapacity = Math.max(writeBuffer.capacity() * 2, class_3532.method_15339((int)need));
                        ByteBuffer newWriteBuffer = ByteBuffer.allocateDirect(newCapacity);
                        writeBuffer.flip();
                        newWriteBuffer.put(writeBuffer);
                        writeBuffer = newWriteBuffer;
                    }
                    writeBuffer.put(readBuffer);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
            writeBuffer.flip();
            ByteBuffer compressedBuffer = Zstd.compress(writeBuffer, Zstd.defaultCompressionLevel());
            try (SeekableByteChannel out = Files.newByteChannel(chunkFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC);){
                out.write(compressedBuffer);
            }
            for (int e = minPosition; e < maxPosition; ++e) {
                Files.deleteIfExists(historyFolder.resolve(ENTRY_PREFIX + e + ".hist"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPosition(Path historyFolder, int position, int size) {
        lock.lock();
        try {
            if (!Files.isDirectory(historyFolder, new LinkOption[0])) {
                Files.deleteIfExists(historyFolder);
            }
            Files.createDirectories(historyFolder, new FileAttribute[0]);
            HistoryIO.completePendingTransaction(historyFolder);
            friendlyDirect.method_52935();
            friendlyDirect.method_52997(1);
            friendlyDirect.method_53002(position);
            friendlyDirect.method_53002(size);
            HistoryIO.beginTransaction(historyFolder, friendlyDirect.nioBuffer());
            HistoryIO.doSetPosition(historyFolder, position, size);
            HistoryIO.endTransaction(historyFolder);
        }
        catch (IOException e) {
            HistoryIO.displayException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private static void doSetPosition(Path historyFolder, int position, int size) throws IOException {
        Path positionPath = historyFolder.resolve("position");
        try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(positionPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC));){
            out.writeInt(position);
            out.writeInt(size);
        }
    }

    public static void clear(Path historyFolder) {
        lock.lock();
        try {
            if (!Files.exists(historyFolder, new LinkOption[0])) {
                return;
            }
            if (!Files.isDirectory(historyFolder, new LinkOption[0])) {
                Files.deleteIfExists(historyFolder);
            }
            Files.createDirectories(historyFolder, new FileAttribute[0]);
            HistoryIO.completePendingTransaction(historyFolder);
            friendlyDirect.method_52935();
            friendlyDirect.method_52997(2);
            HistoryIO.beginTransaction(historyFolder, friendlyDirect.nioBuffer());
            HistoryIO.doClear(historyFolder);
            HistoryIO.endTransaction(historyFolder);
        }
        catch (IOException e) {
            HistoryIO.displayException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private static void doClear(Path historyFolder) throws IOException {
        for (File file : historyFolder.toFile().listFiles()) {
            if (file.isDirectory() || file.getName().contains("transaction")) continue;
            file.delete();
        }
    }

    private static void beginTransaction(Path historyFolder, ByteBuffer byteBuffer) throws IOException {
        Path path = historyFolder.resolve("transaction");
        try (SeekableByteChannel out = Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.SYNC);){
            out.write(byteBuffer);
        }
    }

    private static void endTransaction(Path historyFolder) throws IOException {
        Path path = historyFolder.resolve("transaction");
        Files.delete(path);
    }

    private static void displayException(Exception e) {
        StringBuilder builder = new StringBuilder();
        builder.append("An error occured while updating history").append("\n\n");
        builder.append(e);
        for (StackTraceElement element : e.getStackTrace()) {
            builder.append("\n\tat ").append(element);
        }
        Axiom.LOGGER.error("HistoryIO Exception: " + String.valueOf(builder));
        ClientEvents.pendingAlertScreen = new class_403(() -> {}, (class_2561)class_2561.method_43470((String)"Axiom"), (class_2561)class_2561.method_43470((String)builder.toString()));
    }

    private static void displayWarning(String ... warning) {
        StringBuilder builder = new StringBuilder();
        for (String s2 : warning) {
            builder.append(s2).append("\n");
        }
        Axiom.LOGGER.error("HistoryIO Warning: " + String.valueOf(builder));
        ClientEvents.pendingAlertScreen = new class_403(() -> {}, (class_2561)class_2561.method_43470((String)"Axiom"), (class_2561)class_2561.method_43470((String)builder.toString()));
    }
}

