/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.moulberry.axiom.editor.BlockList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;

public interface BlockCondition {
    public boolean matches(class_2680 var1);

    @Nullable
    public static BlockCondition fromMinecraftOrCustomTag(BlockList.MinecraftOrCustomTagSet tagSet) {
        if (tagSet == null) {
            return null;
        }
        if (tagSet.minecraft() != null) {
            if (tagSet.customSet() != null) {
                return new AnyCondition(List.of(new MatchesTag(tagSet.minecraft()), new MatchesCustomTag(tagSet.customSet())));
            }
            return new MatchesTag(tagSet.minecraft());
        }
        if (tagSet.customSet() != null) {
            return new MatchesCustomTag(tagSet.customSet());
        }
        return null;
    }

    public record AnyCondition(List<BlockCondition> conditions) implements BlockCondition
    {
        @Override
        public boolean matches(class_2680 blockState) {
            for (BlockCondition condition : this.conditions) {
                if (!condition.matches(blockState)) continue;
                return true;
            }
            return false;
        }
    }

    public record MatchesTag(class_6885<class_2248> tag) implements BlockCondition
    {
        @Override
        public boolean matches(class_2680 blockState) {
            return this.tag.method_40241(blockState.method_41520());
        }
    }

    public record MatchesCustomTag(Set<class_2960> customTag) implements BlockCondition
    {
        @Override
        public boolean matches(class_2680 blockState) {
            return this.customTag.contains(blockState.method_26204().method_40142().method_40237().method_29177());
        }
    }

    public record BlockSet(Set<class_2248> set) implements BlockCondition
    {
        @Override
        public boolean matches(class_2680 blockState) {
            return this.set.contains(blockState.method_26204());
        }
    }

    public record StateSet(Set<class_2680> set) implements BlockCondition
    {
        @Override
        public boolean matches(class_2680 blockState) {
            return this.set.contains(blockState);
        }
    }

    public record SpecificBlock(class_2248 block) implements BlockCondition
    {
        @Override
        public boolean matches(class_2680 blockState) {
            return blockState.method_26204() == this.block;
        }
    }

    public record SpecificState(class_2680 blockState) implements BlockCondition
    {
        @Override
        public boolean matches(class_2680 blockState) {
            return blockState == this.blockState;
        }
    }

    public record AnyState(class_2248 block) implements BlockCondition
    {
        @Override
        public boolean matches(class_2680 blockState) {
            return blockState.method_26204() == this.block;
        }
    }
}

