/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.floodfill;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.floodfill.FloodfillTask;
import com.moulberry.axiom.tools.floodfill.FloodfillWaterTask;
import com.moulberry.axiom.tools.magic_select.MagicSelectionTask;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import imgui.ImGui;
import java.text.NumberFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class FloodfillTool
implements Tool {
    private ChunkedBooleanRegion region = new ChunkedBooleanRegion();
    private class_2338 lastFloodedBlockPos = null;
    private class_2338 justAppliedBlockPos = null;
    private final float[] limit = new float[]{100000.0f};
    private boolean propagateUp = false;
    private boolean propagateDown = true;
    private boolean propagateHorizontal = true;
    private boolean propagateCorners = false;
    private Future<FloodfillTask> livePreviewFuture = null;

    @Override
    public void reset() {
        this.lastFloodedBlockPos = null;
        this.region.clear();
        if (this.livePreviewFuture != null) {
            this.livePreviewFuture.cancel(true);
            this.livePreviewFuture = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.rightClick();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    public void rightClick() {
        RayCaster.RaycastResult result = Tool.raycastBlock();
        if (result == null) {
            return;
        }
        class_2338 offset = result.getBlockPos().method_10093(result.getDirection());
        if (offset.equals((Object)this.justAppliedBlockPos)) {
            return;
        }
        this.justAppliedBlockPos = offset;
        class_2680 activeBlock = Tool.getActiveBlock();
        boolean isWater = activeBlock == class_2246.field_10382.method_9564();
        FloodfillTask task = isWater ? new FloodfillWaterTask(new PositionSet(), (class_1937)class_310.method_1551().field_1687, offset, this.getPropagationFlags()) : new FloodfillTask(new PositionSet(), (class_1937)class_310.method_1551().field_1687, offset, this.getPropagationFlags());
        task.fill((int)this.limit[0]);
        PositionSet positionSet = task.positionSet;
        if (positionSet.count() <= 0) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        IntWrapper count = new IntWrapper();
        positionSet.forEachChunk((cx, cy, cz, data) -> {
            if (cy < world.method_32891() || cy > world.method_31597()) {
                return;
            }
            class_2818 chunk = (class_2818)world.method_8402(cx, cz, class_2806.field_12803, false);
            if (chunk == null) {
                return;
            }
            class_2826 section = chunk.method_38259(world.method_31603(cy));
            class_2841 container = section.method_12265();
            int wcx = cx * 16;
            int wcy = cy * 16;
            int wcz = cz * 16;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    short line;
                    if ((line = data[index++]) == 0) continue;
                    for (int x = 0; x < 16; ++x) {
                        class_2680 to;
                        class_2680 oldBlock;
                        if ((line & 1 << x) == 0 || (oldBlock = (class_2680)container.method_12321(x, y, z)).method_26204() == class_2246.field_10243 || isWater && oldBlock.method_26227().method_39360((class_3611)class_3612.field_15910) || (to = isWater && oldBlock.method_28498((class_2769)class_2741.field_12508) ? (class_2680)oldBlock.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)) : activeBlock) == oldBlock) continue;
                        ++count.value;
                        setOperation.set(wcx + x, wcy + y, wcz + z, to);
                        previousBlocksForUndo.set(wcx + x, wcy + y, wcz + z, oldBlock);
                    }
                }
            }
        });
        if (count.value == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(count.value);
        String historyDescription = AxiomI18n.get("axiom.history_description.floodfilled", countString);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, offset, historyDescription, 0), Tool.getSourceInfo(this));
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (Tool.getLookDirection() == null) {
            Selection.render(camera, time, matrices, projection, 7);
            return;
        }
        Selection.render(camera, time, matrices, projection, 4);
        if (this.livePreviewFuture != null && this.livePreviewFuture.isDone()) {
            try {
                FloodfillTask task = this.livePreviewFuture.get();
                this.region.clear();
                task.positionSet.forEach(this.region::add);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            this.livePreviewFuture = null;
        }
        if (this.livePreviewFuture == null) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                return;
            }
            class_2338 offset = result.getBlockPos().method_10093(result.getDirection());
            if (offset.equals((Object)this.justAppliedBlockPos)) {
                return;
            }
            this.justAppliedBlockPos = null;
            if (!offset.equals((Object)this.lastFloodedBlockPos)) {
                this.lastFloodedBlockPos = offset;
                FloodfillTask task = Tool.getActiveBlock() == class_2246.field_10382.method_9564() ? new FloodfillWaterTask(new PositionSet(), (class_1937)class_310.method_1551().field_1687, offset, this.getPropagationFlags()) : new FloodfillTask(new PositionSet(), (class_1937)class_310.method_1551().field_1687, offset, this.getPropagationFlags());
                this.livePreviewFuture = Tool.sharedPoolThreadExecutor.submit(() -> {
                    task.fill((int)this.limit[0]);
                    return task;
                });
            }
        }
        this.region.render(camera, class_243.field_1353, matrices, projection, time, 1);
    }

    private int getPropagationFlags() {
        int flags = 0;
        if (this.propagateUp) {
            flags |= MagicSelectionTask.PROPAGATION_FLAG_UP;
        }
        if (this.propagateDown) {
            flags |= MagicSelectionTask.PROPAGATION_FLAG_DOWN;
        }
        if (this.propagateHorizontal) {
            flags |= MagicSelectionTask.PROPAGATION_FLAG_HORIZONTAL;
        }
        if (this.propagateCorners) {
            flags |= MagicSelectionTask.PROPAGATION_FLAG_CORNERS;
        }
        return flags;
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.floodfill"));
        ImGui.sliderFloat(AxiomI18n.get("axiom.tool.generic.limit"), this.limit, 2.0f, 1.0E7f, "%'.0f", 32);
        if (ImGui.checkbox("Up", this.propagateUp)) {
            this.propagateUp = !this.propagateUp;
        }
        ImGui.sameLine();
        if (ImGui.checkbox("Down", this.propagateDown)) {
            boolean bl = this.propagateDown = !this.propagateDown;
        }
        if (ImGui.checkbox("Horizontal", this.propagateHorizontal)) {
            boolean bl = this.propagateHorizontal = !this.propagateHorizontal;
        }
        if (!this.propagateHorizontal) {
            this.propagateCorners = false;
        } else {
            ImGui.sameLine();
            if (ImGui.checkbox("Corners", this.propagateCorners)) {
                this.propagateCorners = !this.propagateCorners;
            }
        }
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.floodfill");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Floodfill Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        tag.method_10569("Limit", (int)this.limit[0]);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.limit[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "Limit", 100000);
    }

    @Override
    public char iconChar() {
        return '\ue919';
    }

    @Override
    public String keybindId() {
        return "floodfill";
    }
}

