/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.elevation;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.Position2dToFloatMap;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.FalloffWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.pather.ToolPatherPoint;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.HeightmapApplier;
import com.moulberry.axiom.tools.ImageHeightmapProvider;
import com.moulberry.axiom.tools.ServerHeightmaps;
import com.moulberry.axiom.tools.SimpleRadiusAdjustment;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.AutoCleaningDynamicTexture;
import com.moulberry.axiom.utils.BooleanWrapper;
import com.moulberry.axiom.utils.ColourUtils;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.text.NumberFormat;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class ElevationTool
implements Tool {
    private final ChunkedBooleanRegion previewRegion = new ChunkedBooleanRegion();
    private int lastPreviewRadius = -1;
    private int lastPreviewHeight = -1;
    private boolean usingTool = false;
    private int initialY = 70;
    private ToolPatherPoint toolPatherPoint = null;
    private final HeightmapApplier heightmapApplier = new HeightmapApplier();
    private final Position2dToFloatMap heightAccumulation = new Position2dToFloatMap();
    private final Position2dToFloatMap maxFalloffForApplyModeOnce = new Position2dToFloatMap(Float.MIN_VALUE);
    public MaskElement cachedSourceMask = null;
    private MaskContext cachedMaskContext = null;
    private final float[] falloffLut = new float[1057];
    private int falloffLutSize = this.falloffLut.length;
    private long lastUpdateMillis = 0L;
    private CompletableFuture<BufferedImage> loadHeightmapFuture = null;
    private int customHeightmapSize = 0;
    private float customHeightmapZoom = 1.0f;
    private float[] customHeightmap = null;
    private AutoCleaningDynamicTexture heightmapDisplay = null;
    private boolean heightmapDisplayDirty = false;
    private final int[] radius = new int[]{8};
    private final int[] height = new int[]{63};
    private final float[] smoothing = new float[]{1.0f};
    private static final int APPLY_MODE_CONTINUOUS = 0;
    private static final int APPLY_MODE_ONCE = 1;
    private final int[] applyMode = new int[]{0};
    private final int[] rate = new int[]{8};
    private static final int MODE_RAISE = 0;
    private static final int MODE_LOWER = 1;
    private static final int MODE_FLATTEN = 2;
    private static final int MODE_FLATTEN_UP = 3;
    private static final int MODE_FLATTEN_DOWN = 4;
    private final int[] mode = new int[]{0};
    private final FalloffWidget falloffWidget = new FalloffWidget();
    private final PresetWidget presetWidget = new PresetWidget(this, "elevation");
    private boolean settingsChanged = false;
    private final float[] baseRadiusAdjustment = new float[]{0.0f};

    @Override
    public void reset() {
        this.partialReset();
        this.heightAccumulation.clear();
        this.cachedSourceMask = null;
        this.cachedMaskContext = null;
    }

    @Override
    public void toolDeselected() {
        if (this.heightmapDisplay != null) {
            this.heightmapDisplay.close();
            this.heightmapDisplay = null;
        }
        this.falloffWidget.unload();
        this.heightmapDisplayDirty = true;
    }

    private void partialReset() {
        if (this.usingTool) {
            this.usingTool = false;
            ChunkRenderOverrider.INSTANCE.release("elevation_tool");
        }
        this.previewRegion.clear();
        this.lastPreviewRadius = -1;
        this.lastPreviewHeight = -1;
        this.heightmapApplier.reset(this.smoothing[0]);
        this.lastUpdateMillis = System.currentTimeMillis();
        this.maxFalloffForApplyModeOnce.clear();
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                RayCaster.RaycastResult result = Tool.raycastBlock(false, false, Tool.defaultIncludeFluids());
                if (result == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.partialReset();
                int radius = this.radius[0];
                this.falloffLutSize = Math.min(this.falloffLut.length, radius * radius + radius + 1);
                FloatUnaryOperator operator = this.falloffWidget.getFalloffFunction();
                for (int i = 0; i < this.falloffLutSize; ++i) {
                    double distance = Math.sqrt(i) / Math.sqrt(this.falloffLutSize - 1);
                    this.falloffLut[i] = operator.apply((float)distance);
                }
                if (!this.usingTool) {
                    this.usingTool = true;
                    ChunkRenderOverrider.INSTANCE.acquire("elevation_tool");
                }
                this.toolPatherPoint = new ToolPatherPoint(false);
                this.initialY = result.blockPos().method_10264();
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.partialReset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void afterBlockBufferUndo() {
        this.reset();
    }

    @Override
    public void afterBlockBufferRedo() {
        this.reset();
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        Selection.render(camera, time, matrices, projection, 4);
        if (!this.usingTool) {
            RayCaster.RaycastResult result;
            if (this.loadHeightmapFuture != null && this.loadHeightmapFuture.isDone()) {
                BufferedImage image = this.loadHeightmapFuture.join();
                this.setHeightmapImage(image);
            }
            if ((result = Tool.raycastBlock(false, false, Tool.defaultIncludeFluids())) == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            int radius = this.radius[0];
            int height = this.height[0];
            if (this.lastPreviewRadius != radius || this.lastPreviewHeight != height) {
                this.lastPreviewRadius = radius;
                this.lastPreviewHeight = height;
                this.previewRegion.clear();
                float maxRadiusSq = ((float)radius + 0.5f) * ((float)radius + 0.5f);
                for (int x2 = -radius; x2 <= radius; ++x2) {
                    for (int z2 = -radius; z2 <= radius; ++z2) {
                        if (!((float)(x2 * x2 + z2 * z2) < maxRadiusSq)) continue;
                        for (int y = -height; y <= height; ++y) {
                            this.previewRegion.add(x2, y, z2);
                        }
                    }
                }
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.previewRegion.render(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 2);
        } else if (Tool.cancelUsing()) {
            this.partialReset();
        } else if (!Tool.isMouseDown(1)) {
            class_2487 sourceInfo = Tool.getSourceInfo(this);
            String countString = NumberFormat.getInstance().format(this.heightmapApplier.blockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.elevation_tool", countString);
            RegionHelper.pushBlockRegionChange(this.heightmapApplier.blockRegion, historyDescription, sourceInfo);
            this.heightmapApplier.iterateOriginalY((x, z, v) -> {
                int constrainedY = this.heightmapApplier.getConstrainedY(x, z);
                if (constrainedY != Integer.MIN_VALUE) {
                    int delta = constrainedY - v;
                    float accumulated = this.heightAccumulation.get(x, z);
                    if (accumulated > 0.0f) {
                        if (delta < 0 || (float)delta > accumulated) {
                            this.heightAccumulation.put(x, z, 0.0f);
                        } else {
                            this.heightAccumulation.put(x, z, accumulated - (float)delta);
                        }
                    } else if (accumulated < 0.0f) {
                        if (delta > 0 || (float)delta < accumulated) {
                            this.heightAccumulation.put(x, z, 0.0f);
                        } else {
                            this.heightAccumulation.put(x, z, accumulated - (float)delta);
                        }
                    }
                }
            });
            this.partialReset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.process(level);
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.heightmapApplier.blockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            this.heightmapApplier.removeRegion.render(camera, class_243.field_1353, matrices, projection, time, 8);
        }
    }

    private void setHeightmapImage(BufferedImage image) {
        this.loadHeightmapFuture = null;
        this.heightmapDisplayDirty = true;
        this.settingsChanged = true;
        if (image != null) {
            int size = Math.max(image.getWidth(), image.getHeight());
            int offsetX = (size - image.getWidth()) / 2;
            int offsetY = (size - image.getHeight()) / 2;
            float minValue = 0.2f;
            float maxValue = 0.8f;
            float[] values = new float[size * size];
            WritableRaster raster = image.getRaster();
            int type2 = image.getType();
            int index = 0;
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < size; ++y) {
                    float value = 0.0f;
                    if (x >= offsetX && y >= offsetY && x - offsetX < image.getWidth() && y - offsetY < image.getHeight()) {
                        switch (type2) {
                            case 10: {
                                int sample = raster.getSample(x - offsetX, y - offsetY, 0);
                                value = (float)sample / 255.0f;
                                break;
                            }
                            case 11: {
                                int sample = raster.getSample(x - offsetX, y - offsetY, 0);
                                value = (float)sample / 65535.0f;
                                break;
                            }
                            default: {
                                int argb = image.getRGB(x - offsetX, y - offsetY);
                                int red = argb >> 16 & 0xFF;
                                int green = argb >> 8 & 0xFF;
                                int blue = argb & 0xFF;
                                value = (float)(red + green + blue) / 765.0f;
                            }
                        }
                        if (value < minValue) {
                            minValue = value;
                        }
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    values[index++] = value;
                }
            }
            float delta = maxValue - minValue;
            index = 0;
            float maxDistanceSq = 0.5625f;
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < size; ++y) {
                    float distanceY;
                    float distanceX;
                    float distanceSq;
                    float value;
                    int i = index++;
                    values[i] = value = (values[i] - minValue) / delta;
                    if (!(value > 0.05f) || !((distanceSq = (distanceX = (float)x / (float)(size - 1) * 2.0f - 1.0f) * distanceX + (distanceY = (float)y / (float)(size - 1) * 2.0f - 1.0f) * distanceY) > maxDistanceSq)) continue;
                    maxDistanceSq = distanceSq;
                }
            }
            this.customHeightmapZoom = 1.0f / (float)Math.sqrt(maxDistanceSq);
            this.customHeightmapSize = size;
            this.customHeightmap = values;
        }
    }

    private void process(class_638 level) {
        RayCaster.RaycastResult result;
        int radius = this.radius[0];
        int height = this.height[0];
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        BooleanWrapper modified = new BooleanWrapper(false);
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.lastUpdateMillis) {
            this.lastUpdateMillis = currentTime;
            return;
        }
        if (currentTime == this.lastUpdateMillis) {
            return;
        }
        long timeSince = currentTime - this.lastUpdateMillis;
        if (timeSince > 1000L) {
            timeSince = 1000L;
        }
        this.lastUpdateMillis = currentTime;
        float weightThisFrame = (float)((long)this.rate[0] * timeSince) / 1000.0f;
        Position2dToFloatMap maxAccumulateWeight = weightThisFrame > 0.0f && this.applyMode[0] == 0 ? new Position2dToFloatMap(0.0f) : null;
        this.toolPatherPoint.update((x, y, z) -> {
            modified.value = true;
            this.apply(level, radius, height, maxAccumulateWeight, mutableBlockPos, x, y, z);
        });
        if (!modified.value && maxAccumulateWeight != null && (result = Tool.raycastBlock(false, false, Tool.defaultIncludeFluids())) != null) {
            this.apply(level, radius, height, maxAccumulateWeight, mutableBlockPos, result.blockPos().method_10263(), result.blockPos().method_10264(), result.blockPos().method_10260());
        }
        if (maxAccumulateWeight != null) {
            maxAccumulateWeight.forEachEntry((x, z, weight) -> {
                int originalY = this.heightmapApplier.getOriginalY(x, z);
                int count = switch (this.mode[0]) {
                    default -> (int)this.heightAccumulation.add(x, z, weightThisFrame * weight);
                    case 1 -> (int)this.heightAccumulation.add(x, z, -weightThisFrame * weight);
                    case 2 -> {
                        float newHeightAccum;
                        float heightAccum;
                        int delta = originalY - this.initialY;
                        if (delta > 0) {
                            heightAccum = this.heightAccumulation.get(x, z);
                            newHeightAccum = heightAccum - weightThisFrame * weight;
                            if (newHeightAccum <= (float)(-delta)) {
                                this.heightAccumulation.put(x, z, -delta);
                                yield -delta;
                            }
                            this.heightAccumulation.put(x, z, newHeightAccum);
                            yield (int)newHeightAccum;
                        }
                        if (delta < 0) {
                            heightAccum = this.heightAccumulation.get(x, z);
                            newHeightAccum = heightAccum + weightThisFrame * weight;
                            if (newHeightAccum >= (float)(-delta)) {
                                this.heightAccumulation.put(x, z, -delta);
                                yield -delta;
                            }
                            this.heightAccumulation.put(x, z, newHeightAccum);
                            yield (int)newHeightAccum;
                        }
                        yield Integer.MIN_VALUE;
                    }
                    case 3 -> {
                        float newHeightAccum;
                        float heightAccum;
                        int delta = originalY - this.initialY;
                        if (delta < 0) {
                            heightAccum = this.heightAccumulation.get(x, z);
                            newHeightAccum = heightAccum + weightThisFrame * weight;
                            if (newHeightAccum >= (float)(-delta)) {
                                this.heightAccumulation.put(x, z, -delta);
                                yield -delta;
                            }
                            this.heightAccumulation.put(x, z, newHeightAccum);
                            yield (int)newHeightAccum;
                        }
                        yield Integer.MIN_VALUE;
                    }
                    case 4 -> {
                        float newHeightAccum;
                        float heightAccum;
                        int delta = originalY - this.initialY;
                        if (delta > 0) {
                            heightAccum = this.heightAccumulation.get(x, z);
                            newHeightAccum = heightAccum - weightThisFrame * weight;
                            if (newHeightAccum <= (float)(-delta)) {
                                this.heightAccumulation.put(x, z, -delta);
                                yield -delta;
                            }
                            this.heightAccumulation.put(x, z, newHeightAccum);
                            yield (int)newHeightAccum;
                        }
                        yield Integer.MIN_VALUE;
                    }
                };
                if (count == Integer.MIN_VALUE) {
                    return;
                }
                this.heightmapApplier.setModifiedY(x, z, originalY + count);
            });
        }
        this.heightmapApplier.update();
    }

    private void apply(class_638 level, int radius, int height, Position2dToFloatMap maxAccumulateWeight, class_2338.class_2339 mutableBlockPos, int x, int y, int z) {
        class_746 player;
        int maxRadiusSq = radius * radius + radius;
        float expandedMaxRadiusSq = ((float)radius + 1.5f) * ((float)radius + 1.5f);
        int mode = this.mode[0];
        int rate = this.rate[0];
        if (this.cachedSourceMask == null) {
            this.cachedSourceMask = MaskManager.getSourceMask();
            this.cachedMaskContext = new MaskContext((class_1937)level);
        }
        if ((player = class_310.method_1551().field_1724) == null) {
            return;
        }
        double angle = Math.atan2(player.method_19538().field_1352 - (double)x, player.method_19538().field_1350 - (double)z);
        for (int xo = -radius - 1; xo <= radius + 1; ++xo) {
            block1: for (int zo = -radius - 1; zo <= radius + 1; ++zo) {
                int startY;
                int radiusSq = xo * xo + zo * zo;
                if (!((float)radiusSq <= expandedMaxRadiusSq)) continue;
                int originalY = this.heightmapApplier.getOriginalY(x + xo, z + zo);
                if (originalY != Integer.MIN_VALUE) {
                    if (radiusSq > maxRadiusSq) continue;
                    float falloff = this.calculateFalloff(radiusSq, radius, angle, xo, zo);
                    if (maxAccumulateWeight != null) {
                        maxAccumulateWeight.max(x + xo, z + zo, falloff);
                        continue;
                    }
                    if (!this.maxFalloffForApplyModeOnce.max(x + xo, z + zo, falloff)) continue;
                    int amount = Math.round((float)rate * falloff + 0.4f);
                    int newY = this.calculateNewY(mode, amount, originalY);
                    this.heightmapApplier.setModifiedY(x + xo, z + zo, newY);
                    continue;
                }
                int motionBlockingHeight = level.method_8624(class_2902.class_2903.field_13197, x + xo, z + zo);
                for (int h2 = startY = Math.min(motionBlockingHeight, y + height); h2 >= y - height; --h2) {
                    mutableBlockPos.method_10103(x + xo, h2, z + zo);
                    class_2680 block = level.method_8320((class_2338)mutableBlockPos);
                    if (!block.method_51366()) continue;
                    if (radiusSq <= maxRadiusSq && this.cachedSourceMask.test(this.cachedMaskContext.reset(), x + xo, h2, z + zo)) {
                        this.heightmapApplier.setOriginalY(x + xo, z + zo, h2);
                        float falloff = this.calculateFalloff(radiusSq, radius, angle, xo, zo);
                        if (maxAccumulateWeight != null) {
                            this.heightmapApplier.setModifiedY(x + xo, z + zo, h2);
                            maxAccumulateWeight.max(x + xo, z + zo, falloff);
                            continue block1;
                        }
                        if (!this.maxFalloffForApplyModeOnce.max(x + xo, z + zo, falloff) && this.heightmapApplier.getModifiedY(x + xo, z + zo) != Integer.MIN_VALUE) continue block1;
                        int amount = Math.round((float)rate * falloff + 0.4f);
                        int newY = this.calculateNewY(mode, amount, h2);
                        this.heightmapApplier.setModifiedY(x + xo, z + zo, newY);
                        continue block1;
                    }
                    int oldModifiedY = this.heightmapApplier.getModifiedY(x + xo, z + zo);
                    if (oldModifiedY != Integer.MIN_VALUE && oldModifiedY <= h2) continue block1;
                    this.heightmapApplier.setModifiedY(x + xo, z + zo, h2);
                    continue block1;
                }
                int temporaryHeight = Math.min(motionBlockingHeight, y - height - 1);
                int oldModifiedY = this.heightmapApplier.getModifiedY(x + xo, z + zo);
                if (oldModifiedY != Integer.MIN_VALUE && oldModifiedY <= temporaryHeight) continue;
                this.heightmapApplier.setModifiedY(x + xo, z + zo, temporaryHeight);
            }
        }
    }

    private int calculateNewY(int mode, int rate, int h2) {
        return switch (mode) {
            default -> h2 + rate;
            case 1 -> h2 - rate;
            case 2 -> {
                if (h2 > this.initialY) {
                    if (h2 - rate <= this.initialY) {
                        yield this.initialY;
                    }
                    yield h2 - rate;
                }
                if (h2 < this.initialY) {
                    if (h2 + rate >= this.initialY) {
                        yield this.initialY;
                    }
                    yield h2 + rate;
                }
                yield h2;
            }
            case 3 -> {
                if (h2 < this.initialY) {
                    if (h2 + rate >= this.initialY) {
                        yield this.initialY;
                    }
                    yield h2 + rate;
                }
                yield h2;
            }
            case 4 -> {
                if (h2 > this.initialY) {
                    if (h2 - rate <= this.initialY) {
                        yield this.initialY;
                    }
                    yield h2 - rate;
                }
                yield h2;
            }
        };
    }

    private float calculateFalloff(int distanceSq, int maxRadius, double angle, int xo, int zo) {
        if (maxRadius <= 0) {
            return 1.0f;
        }
        float falloff = this.falloffLut[distanceSq * (this.falloffLutSize - 1) / (maxRadius * maxRadius + maxRadius)];
        if (this.customHeightmap != null) {
            int imageYI;
            float rotatedX = (float)xo * (float)Math.cos(angle) - (float)zo * (float)Math.sin(angle);
            float rotatedZ = (float)xo * (float)Math.sin(angle) + (float)zo * (float)Math.cos(angle);
            float partialX = rotatedX / (this.customHeightmapZoom * 2.0f * (float)maxRadius);
            float partialZ = rotatedZ / (this.customHeightmapZoom * 2.0f * (float)maxRadius);
            int size = this.customHeightmapSize;
            float imageX = (partialX + 0.5f) * (float)(size - 1) + 0.5f;
            float imageY = (partialZ + 0.5f) * (float)(size - 1) + 0.5f;
            int imageXI = (int)Math.floor(imageX);
            if (imageXI == size) {
                imageXI = size - 1;
            }
            if ((imageYI = (int)Math.floor(imageY)) == size) {
                imageYI = size - 1;
            }
            if (imageXI >= 0 && imageXI < size && imageYI >= 0 && imageYI < size) {
                float fracX = imageX - (float)imageXI;
                float fracY = imageY - (float)imageYI;
                float totalGray = 0.0f;
                for (int pxo = -1; pxo <= 1; ++pxo) {
                    float weightX = 1.0f - Math.min(1.0f, Math.abs((float)pxo - fracX + 0.5f));
                    for (int pyo = -1; pyo <= 1; ++pyo) {
                        float weightXY = weightX * (1.0f - Math.min(1.0f, Math.abs((float)pyo - fracY + 0.5f)));
                        int pixelX = imageXI + pxo;
                        int pixelY = imageYI + pyo;
                        if (!(weightXY > 0.0f) || pixelX < 0 || pixelX >= size || pixelY < 0 || pixelY >= size) continue;
                        totalGray += this.customHeightmap[pixelX * size + pixelY] * weightXY;
                    }
                }
                falloff *= totalGray;
            } else {
                falloff = 0.0f;
            }
        }
        return falloff;
    }

    @Override
    public void displayImguiOptions() {
        class_1011 pixels;
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        this.settingsChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.generic.brush_radius"), this.radius, 1, 32);
        int[] modifiedHeight = new int[]{this.height[0] + 1};
        this.settingsChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.heightmap.y_limit"), modifiedHeight, 1, 64);
        this.height[0] = modifiedHeight[0] - 1;
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.elevation"));
        this.settingsChanged |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.elevation.mode"), this.mode, new String[]{AxiomI18n.get("axiom.tool.elevation.mode_raise"), AxiomI18n.get("axiom.tool.elevation.mode_lower"), AxiomI18n.get("axiom.tool.elevation.mode_flatten"), AxiomI18n.get("axiom.tool.elevation.mode_flatten_up"), AxiomI18n.get("axiom.tool.elevation.flatten_down")});
        this.settingsChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.heightmap.smoothing"), this.smoothing, 0.0f, 1.0f);
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.elevation.dynamics"));
        this.settingsChanged |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.elevation.apply_mode"), this.applyMode, new String[]{AxiomI18n.get("axiom.tool.elevation.apply_mode.continuous"), AxiomI18n.get("axiom.tool.elevation.apply_mode.once")});
        this.settingsChanged = this.applyMode[0] == 0 ? (this.settingsChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.heightmap.rate"), this.rate, 0, 32)) : (this.settingsChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.heightmap.amount"), this.rate, 0, 32));
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.heightmap.falloff"));
        this.settingsChanged |= this.falloffWidget.displayImgui();
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.elevation.custom_heightmap"));
        if (ImGui.button(AxiomI18n.get("axiom.tool.elevation.load_heightmap"))) {
            this.loadHeightmapFuture = ImageHeightmapProvider.chooseHeightmap();
            this.settingsChanged = true;
        }
        boolean hasServerHeightmaps = false;
        if (ServerHeightmaps.hasHeightmaps()) {
            BufferedImage image;
            hasServerHeightmaps = true;
            if (ImGui.button("Browse Server Heightmaps")) {
                ServerHeightmaps.openHeightmapModal();
            }
            if ((image = ServerHeightmaps.showHeightmapModalIfOpen()) != null) {
                this.setHeightmapImage(image);
            }
        }
        if (this.customHeightmap != null) {
            if (!hasServerHeightmaps) {
                ImGui.sameLine();
            }
            if (ImGui.button(AxiomI18n.get("axiom.widget.clear"))) {
                this.loadHeightmapFuture = null;
                this.customHeightmap = null;
                this.heightmapDisplayDirty = true;
                this.settingsChanged = true;
            }
        }
        float fbScale = Math.max(EditorUI.getIO().getDisplayFramebufferScaleX(), EditorUI.getIO().getDisplayFramebufferScaleY());
        int heightmapDisplaySize = (int)(256.0f * EditorUI.getUiScale());
        int heightmapFramebufferSize = (int)((float)heightmapDisplaySize * fbScale);
        if (this.heightmapDisplay != null && (pixels = this.heightmapDisplay.method_4525()) != null && pixels.method_4307() != heightmapFramebufferSize) {
            this.heightmapDisplayDirty = true;
        }
        if (this.heightmapDisplayDirty) {
            this.heightmapDisplayDirty = false;
            this.uploadHeightmapPreview(heightmapFramebufferSize);
        }
        if (this.heightmapDisplay != null) {
            ImGui.image(this.heightmapDisplay.method_4624(), heightmapDisplaySize, heightmapDisplaySize, 0.0f, 0.0f, 1.0f, 1.0f);
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(this.settingsChanged);
        this.settingsChanged = false;
    }

    private void uploadHeightmapPreview(int heightmapFramebufferSize) {
        if (this.customHeightmap == null) {
            if (this.heightmapDisplay != null) {
                this.heightmapDisplay.close();
                this.heightmapDisplay = null;
            }
        } else {
            class_1011 pixels;
            if (this.heightmapDisplay == null) {
                this.heightmapDisplay = new AutoCleaningDynamicTexture(heightmapFramebufferSize, heightmapFramebufferSize, true);
                pixels = this.heightmapDisplay.method_4525();
            } else {
                pixels = this.heightmapDisplay.method_4525();
                if (pixels == null || pixels.method_4307() != heightmapFramebufferSize) {
                    this.heightmapDisplay.close();
                    this.heightmapDisplay = new AutoCleaningDynamicTexture(heightmapFramebufferSize, heightmapFramebufferSize, true);
                    pixels = this.heightmapDisplay.method_4525();
                }
            }
            Objects.requireNonNull(pixels);
            float maxDistanceSq = 1.0019531f;
            int frameBackgroundABGR = ImGui.getColorU32(7);
            for (int x = 0; x < heightmapFramebufferSize; ++x) {
                for (int y = 0; y < heightmapFramebufferSize; ++y) {
                    int imageYI;
                    float distanceX = (float)x / (float)(heightmapFramebufferSize - 1) * 2.0f - 1.0f;
                    float distanceY = (float)y / (float)(heightmapFramebufferSize - 1) * 2.0f - 1.0f;
                    float distanceSq = distanceX * distanceX + distanceY * distanceY;
                    if (distanceSq > maxDistanceSq) {
                        pixels.method_61941(x, y, ColourUtils.abgrToArgb(frameBackgroundABGR));
                        continue;
                    }
                    float partialX = distanceX / (this.customHeightmapZoom * 2.0f);
                    float partialY = distanceY / (this.customHeightmapZoom * 2.0f);
                    int size = this.customHeightmapSize;
                    float imageX = (partialX + 0.5f) * (float)(size - 1) + 0.5f;
                    float imageY = (partialY + 0.5f) * (float)(size - 1) + 0.5f;
                    int imageXI = (int)Math.floor(imageX);
                    if (imageXI == size) {
                        imageXI = size - 1;
                    }
                    if ((imageYI = (int)Math.floor(imageY)) == size) {
                        imageYI = size - 1;
                    }
                    float falloff = 0.0f;
                    if (imageXI >= 0 && imageXI < size && imageYI >= 0 && imageYI < size) {
                        float fracX = imageX - (float)imageXI;
                        float fracY = imageY - (float)imageYI;
                        float totalGray = 0.0f;
                        for (int xo = -1; xo <= 1; ++xo) {
                            float weightX = 1.0f - Math.min(1.0f, Math.abs((float)xo - fracX + 0.5f));
                            for (int yo = -1; yo <= 1; ++yo) {
                                float weightXY = weightX * (1.0f - Math.min(1.0f, Math.abs((float)yo - fracY + 0.5f)));
                                int pixelX = imageXI + xo;
                                int pixelY = imageYI + yo;
                                if (!(weightXY > 0.0f) || pixelX < 0 || pixelX >= size || pixelY < 0 || pixelY >= size) continue;
                                totalGray += this.customHeightmap[pixelX * size + pixelY] * weightXY;
                            }
                        }
                        falloff = totalGray;
                    }
                    int gray = (int)(falloff * 255.0f);
                    int argb = 0xFF000000 | gray << 16 | gray << 8 | gray;
                    pixels.method_61941(x, y, argb);
                }
            }
            this.heightmapDisplay.method_4524();
        }
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return SimpleRadiusAdjustment.initiateAdjustment(this.radius, this.baseRadiusAdjustment);
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return SimpleRadiusAdjustment.renderAdjustment(mouseX, mouseY, mouseDelta, 32, this.radius, this.baseRadiusAdjustment);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.elevation");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Elevation Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.falloffWidget.writeSettings(tag);
        tag.method_10569("BrushRadius", this.radius[0]);
        tag.method_10569("Height", this.height[0]);
        tag.method_10569("Mode", this.mode[0]);
        tag.method_10548("Smoothing", this.smoothing[0]);
        tag.method_10567("ApplyMode", (byte)this.applyMode[0]);
        tag.method_10569("Rate", this.rate[0]);
        if (this.customHeightmap != null) {
            tag.method_10548("CustomHeightmapZoom", this.customHeightmapZoom);
            tag.method_10569("CustomHeightmapSize", this.customHeightmapSize);
            int[] customHeightmapAsInts = new int[this.customHeightmap.length];
            for (int i = 0; i < this.customHeightmap.length; ++i) {
                customHeightmapAsInts[i] = Float.floatToIntBits(this.customHeightmap[i]);
            }
            tag.method_10539("CustomHeightmapAsInts", customHeightmapAsInts);
        }
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.falloffWidget.loadSettings(tag);
        this.radius[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "BrushRadius", 8);
        this.height[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "Height", 63);
        this.mode[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "Mode", 0);
        this.smoothing[0] = VersionUtilsNbt.helperCompoundTagGetFloatOr(tag, "Smoothing", 1.0f);
        this.applyMode[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "ApplyMode", 0);
        this.rate[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "Rate", 8);
        this.customHeightmap = null;
        if (tag.method_10545("CustomHeightmapAsInts")) {
            int[] customHeightmapAsInts = VersionUtilsNbt.helperCompoundTagGetIntArray(tag, "CustomHeightmapAsInts").orElse(new int[0]);
            int size = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "CustomHeightmapSize", 0);
            if (size * size == customHeightmapAsInts.length) {
                this.customHeightmapZoom = VersionUtilsNbt.helperCompoundTagGetFloatOr(tag, "CustomHeightmapZoom", 1.0f);
                this.customHeightmapSize = size;
                this.customHeightmap = new float[customHeightmapAsInts.length];
                for (int i = 0; i < customHeightmapAsInts.length; ++i) {
                    this.customHeightmap[i] = Float.intBitsToFloat(customHeightmapAsInts[i]);
                }
            }
        }
        this.heightmapDisplayDirty = true;
    }

    @Override
    public char iconChar() {
        return '\ue917';
    }

    @Override
    public String keybindId() {
        return "elevation";
    }

    @Override
    public int defaultKeybind() {
        return 69;
    }
}

