/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.text.NumberFormat;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class SimulateGravityOperation {
    public static void gravity() {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            SimulateGravityOperation.gravity(aabb);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            SimulateGravityOperation.gravity(set);
        }
    }

    private static void gravity(SelectionBuffer.AABB aabb) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        minY = Math.max(world.method_31607(), minY);
        maxY = Math.min(world.method_31600(), maxY);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int movedCount = 0;
        int minWorldY = world.method_31607();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int y;
                class_2680 block;
                int currentY = Integer.MIN_VALUE;
                for (int searchY = minY - 1; searchY >= minWorldY; --searchY) {
                    block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, searchY, z));
                    if (block.method_45474()) continue;
                    currentY = searchY + 1;
                    break;
                }
                if (currentY == Integer.MIN_VALUE) {
                    for (y = minY; y <= maxY; ++y) {
                        block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                        if (block.method_26215()) continue;
                        setOperation.set(x, y, z, class_2246.field_10124.method_9564());
                        previousBlocksForUndo.set(x, y, z, block);
                        ++movedCount;
                    }
                    continue;
                }
                for (y = minY; y <= maxY; ++y) {
                    block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (block.method_26215()) continue;
                    if (currentY != y) {
                        setOperation.set(x, currentY, z, block);
                        previousBlocksForUndo.set(x, currentY, z, world.method_8320((class_2338)mutableBlockPos.method_10103(x, currentY, z)));
                        setOperation.set(x, y, z, class_2246.field_10124.method_9564());
                        previousBlocksForUndo.set(x, y, z, block);
                        ++movedCount;
                    }
                    ++currentY;
                }
            }
        }
        String countString = NumberFormat.getInstance().format(movedCount);
        String historyDescription = AxiomI18n.get("axiom.history_description.moved", countString);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, aabb.center(), historyDescription, 0), Dispatcher.simpleSourceInfo("Simulate Gravity Operation"));
    }

    private static void gravity(SelectionBuffer.Set set) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        IntWrapper movedCount = new IntWrapper();
        int minSection = world.method_32891();
        int maxSection = world.method_31597();
        int sectionCount = world.method_32890();
        int maxWorldY = world.method_31600();
        int minWorldY = world.method_31607();
        LongOpenHashSet visitedChunks = new LongOpenHashSet();
        PositionSet positionSet = set.selectionRegion.unsafeGetPositionSet();
        positionSet.forEachChunk((arg_0, arg_1, arg_2, arg_3) -> SimulateGravityOperation.lambda$gravity$0((LongSet)visitedChunks, sectionCount, minSection, maxSection, positionSet, minWorldY, maxWorldY, world, mutableBlockPos, setOperation, previousBlocksForUndo, movedCount, arg_0, arg_1, arg_2, arg_3));
        String countString = NumberFormat.getInstance().format(movedCount.value);
        String historyDescription = AxiomI18n.get("axiom.history_description.moved", countString);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, set.center(), historyDescription, 0), Dispatcher.simpleSourceInfo("Simulate Gravity Operation"));
    }

    private static /* synthetic */ void lambda$gravity$0(LongSet visitedChunks, int sectionCount, int minSection, int maxSection, PositionSet positionSet, int minWorldY, int maxWorldY, class_638 world, class_2338.class_2339 mutableBlockPos, BlockBuffer setOperation, BlockBuffer previousBlocksForUndo, IntWrapper movedCount, int cx, int cy, int cz, short[] blocks) {
        long chunkPos = class_1923.method_8331((int)cx, (int)cz);
        if (visitedChunks.add(chunkPos)) {
            short[][] sections = new short[sectionCount][];
            for (int i = minSection; i <= maxSection; ++i) {
                short[] section = positionSet.getChunk(cx, i, cz);
                sections[i - minSection] = section;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int wz;
                    class_2680 block;
                    int offset;
                    int y;
                    for (int minY = minWorldY; minY <= maxWorldY; ++minY) {
                        short[] section = sections[(minY >> 4) - minSection];
                        if (section == null) {
                            minY |= 0xF;
                            continue;
                        }
                        int offset2 = (minY & 0xF) + z * 16;
                        if ((section[offset2] & 1 << x) != 0) break;
                    }
                    int currentY = Integer.MIN_VALUE;
                    for (int searchY = minY - 1; searchY >= minWorldY; --searchY) {
                        int wx = cx * 16 + x;
                        int wz2 = cz * 16 + z;
                        class_2680 block2 = world.method_8320((class_2338)mutableBlockPos.method_10103(wx, searchY, wz2));
                        if (block2.method_45474()) continue;
                        currentY = searchY + 1;
                        break;
                    }
                    if (currentY == Integer.MIN_VALUE) {
                        for (y = minY; y < maxWorldY; ++y) {
                            int wx;
                            short[] section = sections[(y >> 4) - minSection];
                            if (section == null) {
                                y |= 0xF;
                                continue;
                            }
                            offset = (y & 0xF) + z * 16;
                            if ((section[offset] & 1 << x) == 0 || (block = world.method_8320((class_2338)mutableBlockPos.method_10103(wx = cx * 16 + x, y, wz = cz * 16 + z))).method_26215()) continue;
                            setOperation.set(wx, y, wz, class_2246.field_10124.method_9564());
                            previousBlocksForUndo.set(wx, y, wz, block);
                            ++movedCount.value;
                        }
                        continue;
                    }
                    for (y = minY; y < maxWorldY; ++y) {
                        int wx;
                        short[] section = sections[(y >> 4) - minSection];
                        if (section == null) {
                            y |= 0xF;
                            continue;
                        }
                        offset = (y & 0xF) + z * 16;
                        if ((section[offset] & 1 << x) == 0 || (block = world.method_8320((class_2338)mutableBlockPos.method_10103(wx = cx * 16 + x, y, wz = cz * 16 + z))).method_26215()) continue;
                        if (currentY != y) {
                            setOperation.set(wx, currentY, wz, block);
                            previousBlocksForUndo.set(wx, currentY, wz, world.method_8320((class_2338)mutableBlockPos.method_10103(wx, currentY, wz)));
                            setOperation.set(wx, y, wz, class_2246.field_10124.method_9564());
                            previousBlocksForUndo.set(wx, y, wz, block);
                            ++movedCount.value;
                        }
                        ++currentY;
                    }
                }
            }
        }
    }
}

