/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.hooks.WorldRenderHook;
import com.moulberry.axiom.tools.Tool;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_746;
import org.joml.Intersectionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class EditorMovementControls {
    public abstract boolean allowGameInputWhileCaptureKeyboard();

    public abstract boolean shouldStop(boolean var1);

    public abstract void update(double var1, double var3);

    public static EditorMovementControls none() {
        return None.INSTANCE;
    }

    public static EditorMovementControls rotate() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return None.INSTANCE;
        }
        if (Configuration.keybind.invertCameraRotate) {
            return new RotateInvert(EditorUI.getMouseForwardsVector(), class_310.method_1551().field_1724.method_36455(), class_310.method_1551().field_1724.method_36454());
        }
        return new Rotate(EditorUI.getMouseForwardsVector(), new class_241(class_310.method_1551().field_1724.method_36455(), class_310.method_1551().field_1724.method_36454()));
    }

    public static EditorMovementControls pan() {
        class_243 planePoint;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return None.INSTANCE;
        }
        if (WorldRenderHook.hasDistance) {
            class_243 lookDelta = EditorUI.getMouseLookVector().method_1021((double)WorldRenderHook.distance);
            planePoint = player.method_33571().method_1019(lookDelta);
        } else {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                return None.INSTANCE;
            }
            planePoint = result.getLocation();
        }
        return new Pan(player.method_19538(), planePoint.method_46409(), player.method_5720().method_46409().negate());
    }

    public static EditorMovementControls arcballFromDepth() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return None.INSTANCE;
        }
        class_243 look = EditorUI.getMouseLookVector();
        if (look == null) {
            return None.INSTANCE;
        }
        class_243 point = player.method_33571().method_1019(look.method_1021((double)WorldRenderHook.distance));
        int minBuildHeight = player.method_37908().method_31607();
        if (point.field_1351 < (double)minBuildHeight) {
            double yDelta = (double)minBuildHeight - point.field_1351;
            if (Math.abs(look.field_1351) > 1.0E-4) {
                double scale = yDelta / look.field_1351;
                point = point.method_1019(look.method_1021(scale));
            }
        }
        class_243 raycastStart = point.method_1019(look.method_1021(-1.0));
        class_243 raycastEnd = point.method_1019(look.method_1021(1.0));
        class_3965 result = player.method_37908().method_17742(new class_3959(raycastStart, raycastEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        if (!result.method_17781() && result.method_17783() == class_239.class_240.field_1332) {
            point = result.method_17784();
        }
        float distance = (float)point.method_1022(player.method_33571());
        return new Arcball(point, distance, true);
    }

    public static EditorMovementControls arcballFromRaycast() {
        class_243 look;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return None.INSTANCE;
        }
        class_243 class_2432 = look = Configuration.keybind.useCenterOfScreenForArcball ? player.method_5720() : EditorUI.getMouseLookVector();
        if (look == null) {
            return None.INSTANCE;
        }
        RayCaster.RaycastResult result = RayCaster.raycast((class_1937)class_310.method_1551().field_1687, player.method_33571().method_46409(), look.method_46409(), false, false);
        if (result == null) {
            return None.INSTANCE;
        }
        class_243 point = result.getLocation();
        float distance = (float)point.method_1022(player.method_33571());
        return new Arcball(point, distance, !Configuration.keybind.useCenterOfScreenForArcball);
    }

    protected static final class None
    extends EditorMovementControls {
        private static final None INSTANCE = new None();

        protected None() {
        }

        @Override
        public boolean allowGameInputWhileCaptureKeyboard() {
            return false;
        }

        @Override
        public boolean shouldStop(boolean isGrabbed) {
            return false;
        }

        @Override
        public void update(double mouseDeltaX, double mouseDeltaY) {
        }
    }

    protected static final class RotateInvert
    extends EditorMovementControls {
        private class_243 oldForwards;
        private float pitch;
        private float yaw;

        public RotateInvert(class_243 forwards, float pitch, float yaw) {
            this.oldForwards = forwards;
            this.pitch = pitch;
            this.yaw = yaw;
        }

        @Override
        public boolean allowGameInputWhileCaptureKeyboard() {
            return true;
        }

        @Override
        public boolean shouldStop(boolean isGrabbed) {
            return !Keybinds.ROTATE_CAMERA.isDownIgnoreMods();
        }

        @Override
        public void update(double mouseDeltaX, double mouseDeltaY) {
            class_243 forwards = EditorUI.getMouseForwardsVector();
            class_746 player = class_310.method_1551().field_1724;
            if (forwards == null || player == null) {
                return;
            }
            double differenceY = forwards.field_1351 - this.oldForwards.field_1351;
            double pitchDelta = Math.toDegrees(Math.asin(differenceY / 2.0)) * 2.0;
            this.pitch = class_3532.method_15393((float)(this.pitch - (float)pitchDelta));
            this.pitch = class_3532.method_15363((float)this.pitch, (float)-90.0f, (float)90.0f);
            double yaw1 = Math.toDegrees(Math.atan2(this.oldForwards.field_1352, this.oldForwards.field_1350));
            double yaw2 = Math.toDegrees(Math.atan2(forwards.field_1352, forwards.field_1350));
            double yawDelta = -class_3532.method_15338((double)(yaw1 - yaw2));
            this.yaw = class_3532.method_15393((float)(this.yaw - (float)yawDelta));
            this.oldForwards = forwards;
            player.method_36457(this.pitch);
            player.method_36456(this.yaw);
        }
    }

    protected static final class Rotate
    extends EditorMovementControls {
        private final class_243 originalForwards;
        private final class_241 originalAngles;

        public Rotate(class_243 originalForwards, class_241 originalAngles) {
            this.originalForwards = originalForwards;
            this.originalAngles = originalAngles;
        }

        @Override
        public boolean allowGameInputWhileCaptureKeyboard() {
            return true;
        }

        @Override
        public boolean shouldStop(boolean isGrabbed) {
            return !Keybinds.ROTATE_CAMERA.isDownIgnoreMods();
        }

        @Override
        public void update(double mouseDeltaX, double mouseDeltaY) {
            class_243 forwards = EditorUI.getMouseForwardsVector();
            class_746 player = class_310.method_1551().field_1724;
            if (forwards == null || player == null) {
                return;
            }
            float pitch = this.originalAngles.field_1343;
            float yaw = this.originalAngles.field_1342;
            class_243 lastVector = this.originalForwards;
            for (int i = 1; i <= 10; ++i) {
                class_243 thisVector = this.originalForwards.method_35590(forwards, (double)((float)i / 10.0f));
                double differenceY = lastVector.field_1351 - thisVector.field_1351;
                double pitchDelta = Math.toDegrees(Math.asin(differenceY / 2.0)) * 2.0;
                pitch = class_3532.method_15393((float)(pitch - (float)pitchDelta));
                pitch = class_3532.method_15363((float)pitch, (float)-90.0f, (float)90.0f);
                double yaw1 = Math.toDegrees(Math.atan2(lastVector.field_1352, lastVector.field_1350));
                double yaw2 = Math.toDegrees(Math.atan2(thisVector.field_1352, thisVector.field_1350));
                double yawDelta = class_3532.method_15338((double)(yaw1 - yaw2));
                Vector3f forwards3f = lastVector.method_35590(thisVector, 0.5).method_46409();
                forwards3f.x = -forwards3f.x;
                forwards3f.z = -forwards3f.z;
                forwards3f.rotateX((float)Math.toRadians(pitch));
                forwards3f.normalize();
                float radius = (float)Math.sqrt(1.0f - forwards3f.y() * forwards3f.y()) * 1.08f;
                if (radius < 0.2f) {
                    radius = 0.2f;
                }
                yaw = class_3532.method_15393((float)(yaw - (float)yawDelta / radius));
                lastVector = thisVector;
            }
            player.method_36457(pitch);
            player.method_36456(yaw);
        }
    }

    protected static final class Pan
    extends EditorMovementControls {
        private final class_243 originalPos;
        private final Vector3f planePoint;
        private final Vector3f planeNormal;

        public Pan(class_243 originalPos, Vector3f planePoint, Vector3f planeNormal) {
            this.originalPos = originalPos;
            this.planePoint = planePoint;
            this.planeNormal = planeNormal;
        }

        @Override
        public boolean allowGameInputWhileCaptureKeyboard() {
            return false;
        }

        @Override
        public boolean shouldStop(boolean isGrabbed) {
            return !Keybinds.PAN_CAMERA.isDownIgnoreMods();
        }

        @Override
        public void update(double mouseDeltaX, double mouseDeltaY) {
            Vector3f view;
            class_243 forwards = EditorUI.getMouseForwardsVector();
            class_746 player = class_310.method_1551().field_1724;
            if (forwards == null || player == null) {
                return;
            }
            Vector3f origin = this.originalPos.method_1031(0.0, (double)player.method_5751(), 0.0).method_46409();
            float distance = Intersectionf.intersectRayPlane((Vector3fc)origin, (Vector3fc)(view = EditorUI.getMouseLookVectorFromForwards(forwards).method_46409()), (Vector3fc)this.planePoint, (Vector3fc)this.planeNormal, (float)1.0E-5f);
            if (distance < 0.0f) {
                return;
            }
            Vector3f targetPoint = origin.add((Vector3fc)new Vector3f((Vector3fc)view).mul(distance));
            Vector3f targetDelta = new Vector3f((Vector3fc)targetPoint).sub((Vector3fc)this.planePoint);
            class_243 finalPos = this.originalPos.method_1023((double)targetDelta.x, (double)targetDelta.y, (double)targetDelta.z);
            player.method_33574(finalPos);
            player.method_22862();
        }
    }

    protected static final class Arcball
    extends EditorMovementControls {
        private final class_243 point;
        private float distance;
        private boolean snapLook;
        private float realXRot = 0.0f;
        private float realYRot = 0.0f;

        public Arcball(class_243 point, float distance, boolean snapLook) {
            this.point = point;
            this.distance = Math.max(1.0f, distance);
            this.snapLook = snapLook;
        }

        @Override
        public boolean allowGameInputWhileCaptureKeyboard() {
            return false;
        }

        @Override
        public boolean shouldStop(boolean isGrabbed) {
            return !isGrabbed;
        }

        @Override
        public void update(double mouseDeltaX, double mouseDeltaY) {
            int invert;
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            if (this.snapLook) {
                this.snapLook = false;
                class_243 look = EditorUI.getMouseLookVector();
                double horizontal = Math.sqrt(look.field_1352 * look.field_1352 + look.field_1350 * look.field_1350);
                float newXRot = class_3532.method_15393((float)((float)Math.toDegrees(-class_3532.method_15349((double)look.field_1351, (double)horizontal))));
                float newYRot = class_3532.method_15393((float)((float)Math.toDegrees(class_3532.method_15349((double)look.field_1350, (double)look.field_1352)) - 90.0f));
                player.method_36457(newXRot);
                player.method_36456(newYRot);
                this.realXRot = newXRot;
                this.realYRot = newYRot;
                return;
            }
            double baseSensitivity = (Double)class_310.method_1551().field_1690.method_42495().method_41753() * (double)0.6f + (double)0.2f;
            double sensitivity = baseSensitivity * baseSensitivity * baseSensitivity * 8.0;
            int n = invert = (Boolean)class_310.method_1551().field_1690.method_42438().method_41753() != false ? -1 : 1;
            if (Keybinds.ARCBALL_CARDINAL_SNAP.isDown()) {
                player.method_36456(this.realYRot);
                player.method_36457(this.realXRot);
                player.method_5872(mouseDeltaX * sensitivity, mouseDeltaY * sensitivity * (double)invert);
                this.realXRot = player.method_36455();
                this.realYRot = player.method_36454();
                class_243 look = player.method_5720();
                if (look.field_1351 < -0.5) {
                    player.method_36457(90.0f);
                } else if (look.field_1351 > 0.5) {
                    player.method_36457(-90.0f);
                } else {
                    player.method_36457(0.0f);
                    player.method_36456((float)Math.round(player.method_36454() / 90.0f) * 90.0f);
                }
            } else {
                player.method_5872(mouseDeltaX * sensitivity, mouseDeltaY * sensitivity * (double)invert);
                this.realXRot = player.method_36455();
                this.realYRot = player.method_36454();
            }
            if (EditorUI.getIO().getMouseWheel() != 0.0f) {
                float wheel = Math.signum(EditorUI.getIO().getMouseWheel());
                float move = this.distance * 0.05f;
                if (move > 4.0f) {
                    move = 4.0f + (float)Math.sqrt(move - 4.0f);
                }
                move *= wheel;
                if (EditorUI.isMoveQuickDown()) {
                    move *= 2.0f;
                }
                this.distance = Math.max(1.0f, this.distance - move);
            }
            class_243 position = this.point.method_1020(player.method_5720().method_1021((double)this.distance));
            class_310.method_1551().field_1724.method_33574(position.method_1023(0.0, (double)player.method_5751(), 0.0));
            class_310.method_1551().field_1724.method_22862();
        }
    }
}

