/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mortennobel.imagescaling.ResampleFilters;
import com.mortennobel.imagescaling.ResampleOp;
import com.moulberry.axiom.GlobalCleaner;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.FramebufferUtils;
import com.moulberry.axiom.utils.ProjectionMatrixBackup;
import com.moulberry.axiom.utils.RenderHelper;
import imgui.ImGui;
import imgui.ImVec2;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.class_1011;
import net.minecraft.class_10366;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.FrustumIntersection;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL30;

public class BlueprintPreview {
    private ChunkedBlockRegion blockRegion = null;
    private CleanState state = null;
    private float yaw = 135.0f;
    private float pitch = 30.0f;
    private float snappedYaw = 135.0f;
    private float snappedPitch = 30.0f;
    private boolean wasSnapped = false;

    public int render(int size, boolean grayBackground, boolean boundingBox) {
        if (this.blockRegion.count() >= 0x1000000) {
            return -1;
        }
        if (this.blockRegion.isEmpty()) {
            return -1;
        }
        if (this.state == null) {
            this.state = new CleanState();
            GlobalCleaner.INSTANCE.register(this, this.state);
        }
        class_276 textureTarget = this.state.textureTarget = FramebufferUtils.resizeOrCreateFramebuffer(this.state.textureTarget, size, size);
        if (grayBackground) {
            FramebufferUtils.clear(textureTarget, 0x4C4C4C4C);
        } else {
            FramebufferUtils.clear(textureTarget, 0);
        }
        int sizeX = this.blockRegion.max().method_10263() + 1 - this.blockRegion.min().method_10263();
        int sizeY = this.blockRegion.max().method_10264() + 1 - this.blockRegion.min().method_10264();
        int sizeZ = this.blockRegion.max().method_10260() + 1 - this.blockRegion.min().method_10260();
        float centerX = (float)(this.blockRegion.min().method_10263() + this.blockRegion.max().method_10263() + 1) / 2.0f;
        float centerY = (float)(this.blockRegion.min().method_10264() + this.blockRegion.max().method_10264() + 1) / 2.0f;
        float centerZ = (float)(this.blockRegion.min().method_10260() + this.blockRegion.max().method_10260() + 1) / 2.0f;
        Quaternionf quaternionf = new Quaternionf();
        quaternionf.rotateAxis((float)Math.toRadians(this.snappedPitch), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
        quaternionf.rotateAxis((float)Math.toRadians(this.snappedYaw), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        Matrix4f projectionMatrix = new Matrix4f().setPerspective((float)Math.toRadians(60.0), 1.0f, 0.1f, 1000.0f);
        FrustumIntersection intersection = new FrustumIntersection();
        intersection.set((Matrix4fc)projectionMatrix);
        float tanHalfFov = (float)Math.tan(Math.toRadians(60.0) * 0.5);
        float distance = 0.0f;
        for (int t1 = 0; t1 < 8; ++t1) {
            Vector3f vec = new Vector3f((float)this.blockRegion.min().method_10263() - centerX + (float)(sizeX * (t1 & 1)), (float)this.blockRegion.min().method_10264() - centerY + (float)(sizeY * (t1 & 2)) / 2.0f, (float)this.blockRegion.min().method_10260() - centerZ + (float)(sizeZ * (t1 & 4)) / 4.0f);
            vec.rotate((Quaternionfc)quaternionf);
            for (int t2 = t1 + 1; t2 < 8; ++t2) {
                Vector3f vec2 = new Vector3f((float)this.blockRegion.min().method_10263() - centerX + (float)(sizeX * (t2 & 1)), (float)this.blockRegion.min().method_10264() - centerY + (float)(sizeY * (t2 & 2)) / 2.0f, (float)this.blockRegion.min().method_10260() - centerZ + (float)(sizeZ * (t2 & 4)) / 4.0f);
                vec2.rotate((Quaternionfc)quaternionf);
                distance = Math.max(distance, Math.abs(vec.x - vec2.x) / (2.0f * tanHalfFov) + Math.abs(vec.z + vec2.z) / 2.0f);
                distance = Math.max(distance, Math.abs(vec.y - vec2.y) / (2.0f * tanHalfFov) + Math.abs(vec.z + vec2.z) / 2.0f);
            }
        }
        distance *= -1.01f;
        float diagonalMultiplier = (float)Math.sin(1.5707963267948966 - Math.toRadians(60.0) * 0.5);
        float[] mins = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE};
        for (int x = 0; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = 0; z <= 1; ++z) {
                    Vector3f vec = new Vector3f((float)this.blockRegion.min().method_10263() - centerX + (float)(sizeX * x), (float)this.blockRegion.min().method_10264() - centerY + (float)(sizeY * y), (float)this.blockRegion.min().method_10260() - centerZ + (float)(sizeZ * z));
                    vec.rotate((Quaternionfc)quaternionf);
                    for (int i = 0; i < 4; ++i) {
                        float to = intersection.distanceToPlane(vec.x, vec.y, vec.z + distance, vec.x, vec.y, vec.z + distance, i) / diagonalMultiplier;
                        if (!(to < mins[i])) continue;
                        mins[i] = to;
                    }
                }
            }
        }
        class_4587 modelViewStack = new class_4587();
        float translationX = (mins[1] - mins[0]) / 2.0f;
        float translationY = (mins[3] - mins[2]) / 2.0f;
        modelViewStack.method_46416(translationX, translationY, distance);
        modelViewStack.method_22907(quaternionf);
        RenderHelper.pushModelViewMatrix(modelViewStack.method_23760().method_23761());
        ProjectionMatrixBackup backup = ProjectionMatrixBackup.create();
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (class_10366)class_10366.field_54954);
        this.blockRegion.render(null, new class_243((double)(-centerX), (double)(-centerY), (double)(-centerZ)), null, modelViewStack, projectionMatrix, 1.0f, 0.0f, false, textureTarget);
        if (boundingBox) {
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
            Shapes.lineBox(new class_4587(), (class_4588)bufferBuilder, (float)this.blockRegion.min().method_10263() - centerX, (float)this.blockRegion.min().method_10264() - centerY, (float)this.blockRegion.min().method_10260() - centerZ, (float)(this.blockRegion.max().method_10263() + 1) - centerX, (float)(this.blockRegion.max().method_10264() + 1) - centerY, (float)(this.blockRegion.max().method_10260() + 1) - centerZ, 1.0f, 1.0f, 1.0f, 0.5f, 0.0f, 0.0f, 0.0f);
            RenderSystem.lineWidth((float)4.0f);
            AxiomRenderPipelines.LINES_IGNORE_DEPTH_WITH_CUSTOM_WIDTH.render(textureTarget, bufferBuilder.method_60794());
            RenderSystem.lineWidth((float)2.0f);
        }
        backup.restore();
        RenderHelper.popModelViewStack();
        int textureId = FramebufferUtils.getRawColorTextureId(this.state.textureTarget);
        GlStateManager._bindTexture((int)textureId);
        GL30.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL30.glTexParameteri((int)3553, (int)10240, (int)9729);
        return textureId;
    }

    public CompletableFuture<class_1011> toNativeImage(int size, boolean crop) {
        CompletionStage future = FramebufferUtils.downloadAsync(this.state.textureTarget).thenApply(nativeImage -> {
            int newHeight;
            int newWidth;
            int minX = size * 10;
            int maxX = 0;
            int minY = size * 10;
            int maxY = 0;
            if (crop) {
                for (int x = 0; x < size * 10; ++x) {
                    for (int y = 0; y < size * 10; ++y) {
                        int argb = nativeImage.method_61940(x, y);
                        int alpha = argb >> 24 & 0xFF;
                        if (alpha <= 20) continue;
                        if (x < minX) {
                            minX = x;
                        }
                        if (y < minY) {
                            minY = y;
                        }
                        if (x + 1 > maxX) {
                            maxX = x + 1;
                        }
                        if (y + 1 <= maxY) continue;
                        maxY = y + 1;
                    }
                }
            }
            if (minX > maxX) {
                minX = 0;
                maxX = size * 10;
            }
            if (minY > maxY) {
                minY = 0;
                maxY = size * 10;
            }
            if ((newWidth = maxX - minX) < (newHeight = maxY - minY)) {
                if ((minX -= (newHeight - newWidth) / 2) < 0) {
                    minX = 0;
                }
                if ((maxX += newHeight - (newWidth = maxX - minX)) > size * 10) {
                    maxX = size * 10;
                }
            } else if (newWidth > newHeight) {
                if ((minY -= (newWidth - newHeight) / 2) < 0) {
                    minY = 0;
                }
                if ((maxY += newWidth - (newHeight = maxY - minY)) > size * 10) {
                    maxY = size * 10;
                }
            }
            BufferedImage bufferedImage = new BufferedImage(maxX - minX, maxY - minY, 2);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    bufferedImage.setRGB(x - minX, y - minY, nativeImage.method_61940(x, y));
                }
            }
            ResampleOp resampleOp = new ResampleOp(size, size);
            resampleOp.setFilter(ResampleFilters.getLanczos3Filter());
            BufferedImage scaledImage = resampleOp.filter(bufferedImage, null);
            nativeImage.close();
            nativeImage = new class_1011(size, size, false);
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < size; ++y) {
                    int argb = scaledImage.getRGB(x, y);
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha <= 20) {
                        nativeImage.method_61941(x, y, 0);
                        continue;
                    }
                    nativeImage.method_61941(x, y, argb);
                }
            }
            return nativeImage;
        });
        return future;
    }

    public void mouseMoved(float dx, float dy, boolean snap) {
        ImVec2 size = ImGui.getMainViewport().getSize();
        float speed = snap ? 360.0f : 180.0f;
        float min2 = Math.min(size.x, size.y);
        if (!snap && this.wasSnapped) {
            this.yaw = this.snappedYaw;
            this.pitch = this.snappedPitch;
            this.wasSnapped = false;
            return;
        }
        this.wasSnapped = snap;
        this.yaw = (this.yaw + dx / min2 * speed) % 360.0f;
        this.pitch = class_3532.method_15363((float)(this.pitch + dy / min2 * speed), (float)-90.0f, (float)90.0f);
        if (this.yaw < -180.0f) {
            this.yaw += 360.0f;
        }
        if (this.yaw >= 180.0f) {
            this.yaw -= 360.0f;
        }
        if (snap) {
            this.snappedYaw = BlueprintPreview.snap(this.yaw);
            this.snappedPitch = BlueprintPreview.snap(this.pitch);
        } else {
            this.snappedYaw = (float)Math.round(this.yaw / 0.01f) * 0.01f;
            this.snappedPitch = (float)Math.round(this.pitch / 0.01f) * 0.01f;
        }
    }

    private static float snap(float in) {
        if ((in %= 360.0f) < -180.0f) {
            in += 360.0f;
        }
        if (in > 180.0f) {
            in -= 360.0f;
        }
        float[] snapTo = new float[]{-180.0f, -150.0f, -135.0f, -120.0f, -90.0f, -60.0f, -45.0f, -30.0f, 0.0f, 30.0f, 45.0f, 60.0f, 90.0f, 120.0f, 135.0f, 150.0f, 180.0f};
        int closestIndex = 0;
        float closestDistance = 360.0f;
        for (int i = 0; i < snapTo.length; ++i) {
            float distance = Math.abs(in - snapTo[i]);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closestIndex = i;
        }
        return snapTo[closestIndex];
    }

    public void mouseReleased() {
        this.yaw = this.snappedYaw;
        this.pitch = this.snappedPitch;
        this.wasSnapped = false;
    }

    public void clear() {
        this.blockRegion = null;
    }

    public float getYaw() {
        return this.snappedYaw;
    }

    public float getPitch() {
        return this.snappedPitch;
    }

    public void setYaw(float yaw, boolean snap) {
        this.yaw = snap ? (this.snappedYaw = BlueprintPreview.snap(yaw)) : (this.snappedYaw = (float)Math.round(yaw / 0.01f) * 0.01f);
    }

    public void setPitch(float pitch, boolean snap) {
        this.pitch = snap ? (this.snappedPitch = BlueprintPreview.snap(pitch)) : (this.snappedPitch = (float)Math.round(pitch / 0.01f) * 0.01f);
    }

    public void setBlockRegion(ChunkedBlockRegion blockRegion) {
        this.blockRegion = blockRegion;
        this.yaw = 135.0f;
        this.pitch = 30.0f;
        this.snappedYaw = 135.0f;
        this.snappedPitch = 30.0f;
        this.wasSnapped = false;
    }

    private static final class CleanState
    implements Runnable,
    AutoCloseable {
        private class_276 textureTarget = null;

        private CleanState() {
        }

        @Override
        public void run() {
            EditorUI.deferredClose(this);
        }

        @Override
        public void close() {
            this.textureTarget.method_1238();
        }
    }
}

