/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.chunk.loading.async_chunk_on_player_login;

import com.google.common.base.Stopwatch;
import com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login.AsyncChunkLoadUtil;
import com.ishland.vmp.common.config.Config;
import com.ishland.vmp.mixins.access.IClientConnection;
import com.ishland.vmp.mixins.access.IServerChunkManager;
import com.ishland.vmp.mixins.access.IThreadedAnvilChunkStorage;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2509;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2661;
import net.minecraft.class_2874;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3324;
import net.minecraft.class_3902;
import net.minecraft.class_5321;
import net.minecraft.class_7633;
import net.minecraft.class_8605;
import net.minecraft.class_8609;
import net.minecraft.class_8610;
import net.minecraft.class_8611;
import net.minecraft.class_8735;
import net.minecraft.class_8791;
import net.minecraft.class_8792;
import net.minecraft.class_9812;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_8610.class})
public abstract class MixinServerConfigurationNetworkHandler
extends class_8609
implements class_8735,
class_7633 {
    @Shadow
    @Final
    private static Logger field_45020;
    @Shadow
    @Final
    private GameProfile field_45022;
    @Shadow
    private class_8791 field_46157;
    @Shadow
    @Final
    private static class_2561 field_45021;
    @Unique
    private static final class_3230<class_3902> VMP_PLAYER_ASYNC_CHUNKS;
    @Unique
    private class_1923 vmp$ticketHeld;
    @Unique
    private class_3218 vmp$ticketHeldWorld;
    @Unique
    private class_3222 vmp$heldPlayer;

    @Shadow
    public abstract boolean method_48106();

    public MixinServerConfigurationNetworkHandler(MinecraftServer server, class_2535 connection, class_8792 clientData) {
        super(server, connection, clientData);
    }

    @Inject(method={"onDisconnected"}, at={@At(value="RETURN")})
    private void onDisconnect(class_9812 info, CallbackInfo ci) {
        this.vmp$dropTicket();
    }

    @Unique
    private void vmp$dropTicket() {
        if (this.vmp$ticketHeld != null && this.vmp$ticketHeldWorld != null) {
            ((IServerChunkManager)this.vmp$ticketHeldWorld.method_14178()).getTicketManager().method_20444(VMP_PLAYER_ASYNC_CHUNKS, this.vmp$ticketHeld, 31, (Object)class_3902.field_17274);
            this.vmp$ticketHeld = null;
            this.vmp$ticketHeldWorld = null;
        }
    }

    @WrapOperation(method={"onReady"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;createPlayer(Lcom/mojang/authlib/GameProfile;Lnet/minecraft/network/packet/c2s/common/SyncedClientOptions;)Lnet/minecraft/server/network/ServerPlayerEntity;")})
    private class_3222 replacePlayer(class_3324 instance, GameProfile profile, class_8791 syncedOptions, Operation<class_3222> original) {
        if (this.vmp$heldPlayer != null) {
            this.vmp$dropTicket();
            return this.vmp$heldPlayer;
        }
        return (class_3222)original.call(new Object[]{instance, profile, syncedOptions});
    }

    @WrapOperation(method={"pollTask"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerConfigurationTask;sendPacket(Ljava/util/function/Consumer;)V")})
    private void delayJoinWorld(class_8605 instance, Consumer<class_2596<?>> packetConsumer, Operation<Void> original) {
        if (instance instanceof class_8611) {
            class_3218 actualWorld;
            class_3222 player;
            class_3324 playerManager = this.field_45012.method_3760();
            if (playerManager.method_14602(this.field_45022.getId()) != null) {
                this.method_52396(class_3324.field_45061);
                return;
            }
            class_2561 text = playerManager.method_14586(this.field_45013.method_10755(), this.field_45022);
            if (text != null) {
                this.method_52396(text);
                return;
            }
            this.vmp$heldPlayer = player = playerManager.method_14613(this.field_45022, this.field_46157);
            class_5321 registryKey = playerManager.method_14600(player).flatMap(nbt -> class_2874.method_28521((Dynamic)new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("Dimension"))).resultOrPartial(arg_0 -> ((Logger)field_45020).error(arg_0))).orElse(class_1937.field_25179);
            class_3218 storedWorld = playerManager.method_14561().method_3847(registryKey);
            if (storedWorld == null) {
                field_45020.warn("Unknown respawn dimension {}, defaulting to overworld", (Object)registryKey);
                actualWorld = playerManager.method_14561().method_30002();
            } else {
                actualWorld = storedWorld;
            }
            class_1923 chunkPos = new class_1923(player.method_24515());
            this.vmp$dropTicket();
            this.vmp$ticketHeld = chunkPos;
            this.vmp$ticketHeldWorld = actualWorld;
            Stopwatch timing = Stopwatch.createStarted();
            AsyncChunkLoadUtil.SEMAPHORE.acquire().thenApplyAsync(unused -> {
                try {
                    ((IServerChunkManager)actualWorld.method_14178()).getTicketManager().method_17290(VMP_PLAYER_ASYNC_CHUNKS, chunkPos, 31, (Object)class_3902.field_17274);
                    ((IServerChunkManager)actualWorld.method_14178()).invokeUpdateChunks();
                    class_3193 chunkHolder = ((IThreadedAnvilChunkStorage)actualWorld.method_14178().field_17254).invokeGetCurrentChunkHolder(chunkPos.method_8324());
                    if (chunkHolder == null) {
                        throw new IllegalStateException("Chunk not there when requested");
                    }
                    return chunkHolder.method_14003().whenCompleteAsync((worldChunkOptionalChunk, throwable) -> {
                        Channel channel;
                        if (Config.SHOW_ASYNC_LOADING_MESSAGES) {
                            field_45020.info("Async chunk loading for player {} completed after {}", (Object)this.field_45022.getName(), (Object)timing);
                        }
                        if ((channel = ((IClientConnection)this.field_45013).getChannel()) == null || !channel.isOpen()) {
                            return;
                        }
                        try {
                            original.call(new Object[]{instance, packetConsumer});
                        }
                        catch (Throwable t1) {
                            field_45020.error("Couldn't place player in world", t1);
                            this.field_45013.method_10743((class_2596)new class_2661(field_45021));
                            this.field_45013.method_10747(field_45021);
                        }
                    }, (Executor)((IThreadedAnvilChunkStorage)actualWorld.method_14178().field_17254).getMainThreadExecutor());
                }
                catch (Throwable t) {
                    field_45020.warn("Failed to schedule chunkload for {} at {}", new Object[]{this.field_45022.getName(), chunkPos, t});
                    try {
                        original.call(new Object[]{instance, packetConsumer});
                    }
                    catch (Throwable t1) {
                        field_45020.error("Couldn't place player in world", t1);
                        this.field_45013.method_10743((class_2596)new class_2661(field_45021));
                        this.field_45013.method_10747(field_45021);
                    }
                    return CompletableFuture.completedFuture(null);
                }
            }, (Executor)((IThreadedAnvilChunkStorage)actualWorld.method_14178().field_17254).getMainThreadExecutor()).whenComplete((completableFuture, throwable) -> AsyncChunkLoadUtil.SEMAPHORE.release());
        } else {
            original.call(new Object[]{instance, packetConsumer});
        }
    }

    static {
        VMP_PLAYER_ASYNC_CHUNKS = class_3230.method_14291((String)"vmp_player_async_chunk", (unit, unit2) -> 0);
    }
}

