/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo;

import io.github.a5b84.helditeminfo.HeldItemInfo;
import io.github.a5b84.helditeminfo.TooltipBuilder;
import io.github.a5b84.helditeminfo.Util;
import io.github.a5b84.helditeminfo.mixin.ItemEnchantmentsComponentAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10129;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9290;
import net.minecraft.class_9300;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import net.minecraft.class_9792;
import net.minecraft.class_9793;

public final class Appenders {
    private static final class_2583 LORE_STYLE = class_2583.field_24360.method_10977(TooltipBuilder.DEFAULT_COLOR).method_10978(Boolean.valueOf(true));
    private static final class_2561 UNBREAKABLE_TEXT = class_2561.method_43471((String)"item.unbreakable").method_27692(TooltipBuilder.DEFAULT_COLOR);

    private Appenders() {
    }

    public static void appendMusicDiscDescription(TooltipBuilder builder) {
        class_9792 songComponent = (class_9792)builder.stack.method_57824(class_9334.field_52175);
        if (songComponent != null && (!HeldItemInfo.config.respectHideFlags() || songComponent.comp_2834())) {
            songComponent.comp_2833().method_60739(builder.tooltipContext.method_59527()).ifPresent(entry -> builder.append(() -> {
                class_5250 description = ((class_9793)entry.comp_349()).comp_2836().method_27661();
                return class_2564.method_10889((class_5250)description, (class_2583)class_2583.field_24360.method_10977(TooltipBuilder.DEFAULT_COLOR));
            }));
        }
    }

    public static void appendEnchantments(TooltipBuilder builder) {
        Appenders.appendEnchantments(builder, (class_9331<class_9304>)class_9334.field_49643);
        Appenders.appendEnchantments(builder, (class_9331<class_9304>)class_9334.field_49633);
    }

    private static void appendEnchantments(TooltipBuilder builder, class_9331<class_9304> componentType) {
        class_9304 enchantments = (class_9304)builder.stack.method_57824(componentType);
        if (enchantments == null || enchantments.method_57543() || HeldItemInfo.config.respectHideFlags() && !((ItemEnchantmentsComponentAccessor)enchantments).getShowInTooltip()) {
            return;
        }
        class_6885 tooltipOrder = ItemEnchantmentsComponentAccessor.callGetTooltipOrderList(builder.tooltipContext.method_59527(), class_7924.field_41265, class_9636.field_51362);
        for (class_6880 enchantment : tooltipOrder) {
            int level = enchantments.method_57536(enchantment);
            if (level <= 0 || !Appenders.shouldShowEnchantment((class_6880<class_1887>)enchantment)) continue;
            builder.append(() -> class_1887.method_8179((class_6880)enchantment, (int)level));
        }
        for (Object2IntMap.Entry mapEntry : enchantments.method_57539()) {
            class_6880 enchantment = (class_6880)mapEntry.getKey();
            if (tooltipOrder.method_40241(enchantment) || !Appenders.shouldShowEnchantment((class_6880<class_1887>)enchantment)) continue;
            builder.append(() -> {
                int level = mapEntry.getIntValue();
                return class_1887.method_8179((class_6880)enchantment, (int)level);
            });
        }
    }

    private static boolean shouldShowEnchantment(class_6880<class_1887> entry) {
        List<class_2960> filters = HeldItemInfo.filteredEnchantments;
        if (filters.isEmpty()) {
            return true;
        }
        class_2960 id = entry.method_40230().map(class_5321::method_29177).orElse(null);
        return filters.contains(id) == HeldItemInfo.config.showOnlyFilteredEnchantments();
    }

    public static void appendItem(TooltipBuilder builder, class_2487 itemNbt) {
        class_1799 stack;
        if (itemNbt == null || itemNbt.method_33133()) {
            return;
        }
        Optional optionalStack = class_1799.method_57360((class_7225.class_7874)builder.tooltipContext.method_59527(), (class_2520)itemNbt);
        if (optionalStack.isEmpty() || (stack = (class_1799)optionalStack.get()).method_7960()) {
            return;
        }
        builder.append(() -> class_2561.method_43469((String)"container.shulkerBox.itemCount", (Object[])new Object[]{stack.method_7964(), stack.method_7947()}).method_27692(TooltipBuilder.DEFAULT_COLOR));
    }

    public static void appendLore(TooltipBuilder builder) {
        class_9290 loreComponent = (class_9290)builder.stack.method_57824(class_9334.field_49632);
        if (loreComponent != null) {
            int currentLoreLines = 0;
            for (class_2561 line : loreComponent.comp_2400()) {
                int maxLines = Math.min(HeldItemInfo.config.maxLoreLines() - currentLoreLines, builder.getRemainingLines());
                List<class_5250> wrappedLine = Util.wrapLines((class_5348)line, maxLines);
                for (class_5250 linePart : wrappedLine) {
                    builder.append(() -> class_2564.method_10889((class_5250)linePart, (class_2583)LORE_STYLE));
                }
            }
        }
    }

    public static void appendUnbreakable(TooltipBuilder builder) {
        class_9300 unbreakableComponent = (class_9300)builder.stack.method_57824(class_9334.field_49630);
        if (unbreakableComponent != null && (!HeldItemInfo.config.respectHideFlags() || unbreakableComponent.comp_2417())) {
            builder.append(UNBREAKABLE_TEXT);
        }
    }

    public static void appendOminousBottleAmplifier(TooltipBuilder builder) {
        class_10129 component = (class_10129)builder.stack.method_57824(class_9334.field_50238);
        if (component != null) {
            component.method_57409(builder.tooltipContext, builder::append, (class_1836)class_1836.field_41070);
        }
    }
}

