/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.overlay.logic;

import dev.tr7zw.itemswapper.api.AvailableSlot;
import dev.tr7zw.itemswapper.api.client.ItemSwapperClientAPI;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemList;
import dev.tr7zw.itemswapper.overlay.SwitchItemOverlay;
import dev.tr7zw.itemswapper.overlay.logic.GuiSlot;
import dev.tr7zw.itemswapper.overlay.logic.ItemGridWidget;
import dev.tr7zw.itemswapper.util.InventoryUtil;
import dev.tr7zw.itemswapper.util.ItemUtil;
import dev.tr7zw.itemswapper.util.NetworkUtil;
import dev.tr7zw.itemswapper.util.RenderHelper;
import dev.tr7zw.itemswapper.util.WidgetUtil;
import dev.tr7zw.trender.gui.client.RenderContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;

public class ListContentWidget
extends ItemGridWidget {
    private final ItemList itemSelection;
    private final List<AvailableSlot> entries = new ArrayList<AvailableSlot>();

    public ListContentWidget(ItemList items, int x, int y) {
        super(x, y);
        this.itemSelection = items;
        this.refreshList();
        WidgetUtil.setupDynamicSlots(this.widgetArea, this.slots, this.entries.size());
    }

    private void refreshList() {
        this.entries.clear();
        for (class_1792 item : this.itemSelection.getItems()) {
            List<AvailableSlot> ids = this.providerManager.findSlotsMatchingItem(item, false, false);
            for (AvailableSlot id : ids) {
                if (this.entries.contains(id)) continue;
                this.entries.add(id);
            }
        }
    }

    private List<AvailableSlot> getItem(int id) {
        return id > this.entries.size() - 1 ? Collections.emptyList() : Collections.singletonList(this.entries.get(id));
    }

    @Override
    protected void renderSlot(RenderContext graphics, int x, int y, List<Runnable> itemRenderList, GuiSlot guiSlot, boolean overwrideAvailable) {
        List<AvailableSlot> slots = this.getItem(guiSlot.id());
        if (!slots.isEmpty() && !overwrideAvailable) {
            itemRenderList.add(() -> RenderHelper.renderSlot(graphics, x + 3, y + 4, (class_1657)this.minecraft.field_1724, ((AvailableSlot)slots.get(0)).item(), 1, RenderHelper.SlotEffect.NONE, ((AvailableSlot)slots.get(0)).amount().get()));
        } else if (guiSlot.id() <= this.entries.size() - 1) {
            itemRenderList.add(() -> RenderHelper.renderSlot(graphics, x + 3, y + 4, (class_1657)this.minecraft.field_1724, this.entries.get(guiSlot.id()).item(), 1, !overwrideAvailable ? RenderHelper.SlotEffect.RED : RenderHelper.SlotEffect.NONE, 1));
        }
    }

    @Override
    public void onSecondaryClick(SwitchItemOverlay overlay, GuiSlot slot, int xOffset, int yOffset) {
    }

    @Override
    public boolean onPrimaryClick(SwitchItemOverlay overlay, GuiSlot guiSlot, int xOffset, int yOffset) {
        if (guiSlot.id() > this.entries.size() - 1) {
            return true;
        }
        AvailableSlot entry = this.entries.get(guiSlot.id());
        if (entry != null && !entry.item().method_7960()) {
            ItemSwapperClientAPI.OnSwap event = this.clientAPI.prepareItemSwapEvent.callEvent(new ItemSwapperClientAPI.OnSwap(entry, new AtomicBoolean()));
            if (event.canceled().get()) {
                return true;
            }
            if (entry.inventory() == -1) {
                int hudSlot = ItemUtil.inventorySlotToHudSlot(entry.slot());
                this.minecraft.field_1761.method_2906(this.minecraft.field_1724.field_7498.field_7763, hudSlot, InventoryUtil.getSelectedId(this.minecraft.field_1724.method_31548()), class_1713.field_7791, (class_1657)this.minecraft.field_1724);
            } else {
                NetworkUtil.swapItem(entry.inventory(), entry.slot());
            }
            this.clientAPI.itemSwapSentEvent.callEvent(new ItemSwapperClientAPI.SwapSent(entry));
            return false;
        }
        return true;
    }

    @Override
    public void renderSelectedSlotName(GuiSlot selected, int yOffset, int maxWidth, boolean overwrideAvailable, RenderContext graphics) {
        if (selected.id() > this.entries.size() - 1) {
            return;
        }
        AvailableSlot slot = this.entries.get(selected.id());
        if (slot == null) {
            return;
        }
        RenderHelper.renderSelectedItemName(ItemUtil.getDisplayname(slot.item()), slot.item(), false, yOffset, maxWidth, graphics);
    }
}

