/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import dzwdz.chat_heads.Compat;
import dzwdz.chat_heads.HeadData;
import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigDefaults;
import dzwdz.chat_heads.config.ClothConfigCommonImpl;
import dzwdz.chat_heads.config.RenderPosition;
import dzwdz.chat_heads.config.SenderDetection;
import dzwdz.chat_heads.mixininterface.HeadRenderable;
import dzwdz.chat_heads.mixininterface.Ownable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1011;
import net.minecraft.class_1921;
import net.minecraft.class_2556;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_7417;
import net.minecraft.class_7463;
import net.minecraft.class_7471;
import net.minecraft.class_9848;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatHeads {
    public static final String MOD_ID = "chat_heads";
    public static final String FORMAT_REGEX = "\u00a7.";
    public static final Logger LOGGER = LogManager.getLogger((String)"chat_heads");
    public static final class_2960 DISABLE_RESOURCE = class_2960.method_60655((String)"chat_heads", (String)"disable");
    public static ChatHeadsConfig CONFIG = new ChatHeadsConfigDefaults();
    @NotNull
    public static HeadData lastSenderData = HeadData.EMPTY;
    public static boolean refreshing;
    @NotNull
    public static HeadData lineData;
    @NotNull
    public static HeadData refreshingLineData;
    public static volatile boolean serverSentUuid;
    public static volatile boolean serverDisabledChatHeads;
    public static final Set<class_2960> blendedHeadTextures;
    public static class_332 guiGraphics;
    @NotNull
    public static HeadData renderHeadData;
    public static float renderHeadOpacity;
    public static boolean forceBeforeLine;
    private static final Map<String, BooleanSupplier> beforeNameIncompatibility;

    public static void init() {
        for (Map.Entry<String, BooleanSupplier> entry : beforeNameIncompatibility.entrySet()) {
            String modId = entry.getKey();
            if (!Compat.isModLoaded(modId) || !entry.getValue().getAsBoolean()) continue;
            forceBeforeLine = true;
            LOGGER.warn("disabled \"Before Name\" rendermode due to incompatibility with {}", (Object)modId);
        }
        if (Compat.isClothConfigLoaded()) {
            ClothConfigCommonImpl.loadConfig();
        }
    }

    @NotNull
    public static HeadData getLineData() {
        return refreshing ? refreshingLineData : lineData;
    }

    public static void setLineData(@NotNull HeadData headData) {
        if (refreshing) {
            refreshingLineData = headData;
        } else {
            lineData = headData;
        }
    }

    public static void handleAddedMessage(class_2561 message, @Nullable class_2556.class_7602 bound, @Nullable class_640 playerInfo) {
        if (serverDisabledChatHeads) {
            lastSenderData = HeadData.EMPTY;
            return;
        }
        lastSenderData = ChatHeads.detectPlayer(message, bound, playerInfo);
    }

    @NotNull
    private static HeadData detectPlayer(class_2561 message, @Nullable class_2556.class_7602 bound, @Nullable class_640 playerInfo) {
        HeadData headData = ChatHeads.detectShowcaseItemMessage(message);
        if (headData != null) {
            return headData;
        }
        if (CONFIG.senderDetection() != SenderDetection.HEURISTIC_ONLY) {
            if (playerInfo != null) {
                serverSentUuid = true;
                return HeadData.of(playerInfo);
            }
            if (CONFIG.senderDetection() == SenderDetection.UUID_ONLY || serverSentUuid && CONFIG.smartHeuristics()) {
                return HeadData.EMPTY;
            }
        }
        return ChatHeads.detectPlayerByHeuristic(message, bound);
    }

    @Nullable
    private static HeadData detectShowcaseItemMessage(class_2561 message) {
        class_2588 contents;
        class_7417 class_74172 = message.method_10851();
        if (class_74172 instanceof class_2588 && Objects.equals((contents = (class_2588)class_74172).method_11022(), "showcaseitem.misc.shared_item") && contents.method_11023().length > 0) {
            String playerName;
            class_634 connection = class_310.method_1551().method_1562();
            if (connection == null) {
                return null;
            }
            Object object = contents.method_11023()[0];
            if (object instanceof String) {
                String s;
                playerName = s = (String)object;
            } else {
                object = contents.method_11023()[0];
                if (object instanceof class_2561) {
                    class_2561 c = (class_2561)object;
                    playerName = c.getString();
                } else {
                    return null;
                }
            }
            PlayerInfoCache playerInfoCache = new PlayerInfoCache(connection);
            playerInfoCache.collectAllNames();
            return HeadData.of(playerInfoCache.get(playerName));
        }
        return null;
    }

    @NotNull
    public static HeadData getHeadData(@NotNull class_303.class_7590 guiMessage) {
        return ((HeadRenderable)guiMessage).chatheads$getHeadData();
    }

    @NotNull
    public static HeadData getHeadData(@NotNull class_303 guiMessage) {
        return ((HeadRenderable)guiMessage).chatheads$getHeadData();
    }

    @Nullable
    public static class_640 getOwner(@NotNull class_7471 message) {
        return ((Ownable)message).chatheads$getOwner();
    }

    public static void setHeadData(@NotNull class_303 guiMessage, @NotNull HeadData data) {
        ((HeadRenderable)guiMessage).chatheads$setHeadData(data);
    }

    public static void setOwner(@NotNull class_7471 message, class_640 owner) {
        ((Ownable)message).chatheads$setOwner(owner);
    }

    public static int getChatOffset(@NotNull class_303.class_7590 guiMessage) {
        return ChatHeads.getChatOffset(ChatHeads.getHeadData(guiMessage));
    }

    public static int getChatOffset(@NotNull HeadData headData) {
        if (CONFIG.renderPosition() != RenderPosition.BEFORE_LINE) {
            return 0;
        }
        if (headData != HeadData.EMPTY || CONFIG.offsetNonPlayerText() && !serverDisabledChatHeads) {
            return 10;
        }
        return 0;
    }

    @NotNull
    public static HeadData detectPlayerByHeuristic(class_2561 message, @Nullable class_2556.class_7602 bound) {
        class_634 connection = class_310.method_1551().method_1562();
        if (connection == null) {
            return HeadData.EMPTY;
        }
        class_2561 sender = ChatHeads.getSenderDecoration(bound);
        PlayerInfoCache playerInfoCache = new PlayerInfoCache(connection);
        playerInfoCache.collectProfileNames();
        class_640 player = ChatHeads.getTellReceiver(sender != null ? sender : message).map(playerInfoCache::get).orElse(null);
        if (player != null) {
            return HeadData.of(player);
        }
        playerInfoCache.collectAllNames();
        if (sender != null) {
            String cleanSender = sender.getString().replaceAll(FORMAT_REGEX, "");
            return HeadData.of(playerInfoCache.get(cleanSender));
        }
        return ChatHeads.scanForPlayerName(message.getString(), playerInfoCache);
    }

    private static Optional<String> getTellReceiver(class_2561 component) {
        return component.method_27658((style, string) -> {
            String cmd;
            class_2558 clickEvent = style.method_10970();
            if (clickEvent != null && clickEvent.method_10845() == class_2558.class_2559.field_11745 && (cmd = clickEvent.method_10844()) != null && cmd.startsWith("/tell ")) {
                String name = cmd.substring("/tell ".length()).trim();
                return Optional.of(name);
            }
            return Optional.empty();
        }, class_2583.field_24360);
    }

    @Nullable
    private static class_2561 getSenderDecoration(@Nullable class_2556.class_7602 bound) {
        if (bound == null) {
            return null;
        }
        for (class_7463.class_7464 param : ((class_2556)bound.comp_919().comp_349()).comp_792().comp_789()) {
            if (param != class_7463.class_7464.field_39220) continue;
            return bound.comp_920();
        }
        return null;
    }

    @NotNull
    public static HeadData scanForPlayerName(@NotNull String message, PlayerInfoCache playerInfoCache) {
        message = message.replaceAll(FORMAT_REGEX, "");
        Map<Integer, List<String>> namesByFirstCharacter = playerInfoCache.createNamesByFirstCharacterMap();
        boolean insideWord = false;
        int[] messageSeq = message.codePoints().toArray();
        for (int i = 0; i < messageSeq.length; ++i) {
            int c = messageSeq[i];
            if (insideWord && ChatHeads.isWordCharacter(c)) continue;
            for (String name : namesByFirstCharacter.getOrDefault(c, List.of())) {
                boolean nameIsFollowedByWord;
                int[] nameSeq = name.codePoints().toArray();
                if (i + nameSeq.length - 1 >= messageSeq.length) continue;
                boolean nameEndsAsWord = ChatHeads.isWordCharacter(nameSeq[nameSeq.length - 1]);
                boolean bl = nameIsFollowedByWord = i + nameSeq.length < messageSeq.length && ChatHeads.isWordCharacter(messageSeq[i + nameSeq.length]);
                if (nameEndsAsWord && nameIsFollowedByWord || !ChatHeads.containsSubsequenceAt(messageSeq, i, nameSeq)) continue;
                return new HeadData(playerInfoCache.get(name), i);
            }
            insideWord = ChatHeads.isWordCharacter(c);
        }
        return HeadData.EMPTY;
    }

    private static boolean isWordCharacter(int codePoint) {
        return Character.isLetterOrDigit(codePoint) || codePoint == 95 || Character.getNumericValue(codePoint) != -1;
    }

    private static boolean containsSubsequenceAt(int[] sequence, int startIndex, int[] subsequence) {
        for (int j = 0; j < subsequence.length; ++j) {
            if (sequence[startIndex + j] == subsequence[j]) continue;
            return false;
        }
        return true;
    }

    public static class_1011 extractBlendedHead(class_1011 skin) {
        boolean isLegacy = skin.method_4307() / 2 == skin.method_4323();
        int xScale = skin.method_4307() / 64;
        int yScale = skin.method_4323() / (isLegacy ? 32 : 64);
        class_1011 head = new class_1011(8 * xScale, 8 * yScale, false);
        for (int y = 0; y < head.method_4323(); ++y) {
            for (int x = 0; x < head.method_4307(); ++x) {
                int headColor = skin.method_61940(8 * xScale + x, 8 * yScale + y);
                int hatColor = skin.method_61940(40 * xScale + x, 8 * yScale + y);
                head.method_61941(x, y, ChatHeads.blendColors(headColor, hatColor));
            }
        }
        return head;
    }

    public static int blendColors(int color1, int color2) {
        float a1 = (float)class_9848.method_61320((int)color1) / 255.0f;
        float r1 = (float)class_9848.method_61327((int)color1) / 255.0f;
        float g1 = (float)class_9848.method_61329((int)color1) / 255.0f;
        float b1 = (float)class_9848.method_61331((int)color1) / 255.0f;
        float a2 = (float)class_9848.method_61320((int)color2) / 255.0f;
        float r2 = (float)class_9848.method_61327((int)color2) / 255.0f;
        float g2 = (float)class_9848.method_61329((int)color2) / 255.0f;
        float b2 = (float)class_9848.method_61331((int)color2) / 255.0f;
        float a3 = a2 * a2 + (1.0f - a2) * a1;
        float r3 = a2 * r2 + (1.0f - a2) * r1;
        float g3 = a2 * g2 + (1.0f - a2) * g1;
        float b3 = a2 * b2 + (1.0f - a2) * b1;
        return class_9848.method_61324((int)((int)Math.clamp(a3 * 255.0f, 0.0f, 255.0f)), (int)((int)Math.clamp(r3 * 255.0f, 0.0f, 255.0f)), (int)((int)Math.clamp(g3 * 255.0f, 0.0f, 255.0f)), (int)((int)Math.clamp(b3 * 255.0f, 0.0f, 255.0f)));
    }

    public static class_2960 getBlendedHeadLocation(class_2960 skinLocation) {
        return class_2960.method_60655((String)MOD_ID, (String)skinLocation.method_12832());
    }

    public static void renderChatHead(class_332 guiGraphics, int x, int y, class_640 owner, float opacity) {
        class_2960 skinLocation = owner.method_52810().comp_1626();
        int color = class_9848.method_61317((float)opacity);
        if (blendedHeadTextures.contains(skinLocation)) {
            guiGraphics.method_25293(class_1921::method_62277, ChatHeads.getBlendedHeadLocation(skinLocation), x, y, 0.0f, 0.0f, 8, 8, 8, 8, 8, 8, color);
        } else {
            guiGraphics.method_25293(class_1921::method_62277, skinLocation, x, y, 8.0f, 8.0f, 8, 8, 8, 8, 64, 64, color);
            guiGraphics.method_25293(class_1921::method_62277, skinLocation, x, y, 40.0f, 8.0f, 8, 8, 8, 8, 64, 64, color);
        }
    }

    static {
        lineData = HeadData.EMPTY;
        refreshingLineData = HeadData.EMPTY;
        serverSentUuid = false;
        serverDisabledChatHeads = false;
        blendedHeadTextures = new HashSet<class_2960>();
        renderHeadData = HeadData.EMPTY;
        beforeNameIncompatibility = Map.of("caxton", () -> true, "modernui", () -> {
            try {
                Class<?> modernUi;
                if (Compat.isModLoaded("emojiful")) {
                    return false;
                }
                try {
                    modernUi = Class.forName("icyllis.modernui.mc.ModernUIMod");
                }
                catch (ClassNotFoundException e) {
                    modernUi = Class.forName("icyllis.modernui.mc.forge.ModernUIForge");
                }
                return (Boolean)modernUi.getMethod("isTextEngineEnabled", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn("couldn't invoke isTextEngineEnabled: {}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                return false;
            }
        });
    }

    public static class PlayerInfoCache {
        private final class_634 connection;
        private final Map<String, class_640> playerInfos = new HashMap<String, class_640>();
        private boolean collectedProfileNames = false;
        private boolean collectedEverything = false;

        public PlayerInfoCache(@NotNull class_634 connection) {
            this.connection = connection;
        }

        public void collectProfileNames() {
            if (this.collectedProfileNames) {
                return;
            }
            this.collectedProfileNames = true;
            for (class_640 playerInfo : this.connection.method_2880()) {
                this.addProfileName(playerInfo);
            }
        }

        private void addProfileName(class_640 playerInfo) {
            String profileName = playerInfo.method_2966().getName().replaceAll(ChatHeads.FORMAT_REGEX, "");
            if (profileName.isEmpty()) {
                return;
            }
            this.playerInfos.put(profileName, playerInfo);
        }

        public void collectAllNames() {
            if (this.collectedEverything) {
                return;
            }
            this.collectedEverything = true;
            this.collectProfileNames();
            for (class_640 playerInfo : this.connection.method_2880()) {
                this.addDisplayName(playerInfo);
            }
            this.addNameAliases();
        }

        private void addNameAliases() {
            for (Map.Entry<String, String> entry : CONFIG.getNameAliases().entrySet()) {
                class_640 playerInfo = this.playerInfos.get(entry.getValue());
                if (playerInfo == null) continue;
                this.playerInfos.putIfAbsent(entry.getKey(), playerInfo);
            }
        }

        private void addDisplayName(class_640 playerInfo) {
            if (playerInfo.method_2971() != null) {
                String displayName = playerInfo.method_2971().getString().replaceAll(ChatHeads.FORMAT_REGEX, "");
                if (displayName.isEmpty()) {
                    return;
                }
                this.playerInfos.putIfAbsent(displayName, playerInfo);
            }
        }

        public void add(class_640 playerInfo) {
            this.addProfileName(playerInfo);
            this.addDisplayName(playerInfo);
            this.addNameAliases();
        }

        public Map<Integer, List<String>> createNamesByFirstCharacterMap() {
            HashMap<Integer, List<String>> namesByFirstCharacter = new HashMap<Integer, List<String>>();
            for (String name : this.playerInfos.keySet()) {
                namesByFirstCharacter.compute(name.codePointAt(0), (key, value) -> {
                    if (value == null) {
                        value = new ArrayList<String>();
                    }
                    value.add(name);
                    return value;
                });
            }
            return namesByFirstCharacter;
        }

        @Nullable
        public class_640 get(@NotNull String name) {
            return this.playerInfos.get(name);
        }

        public Set<String> getNames() {
            return this.playerInfos.keySet();
        }
    }
}

